
<?php $__env->startSection('style'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">


        <div class="row">
            <div class="alert-validation mb-0 pb-0">
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul class="list-unstyled m-0 p-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <?php echo e($error); ?>

                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </ul>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </div>
                <?php endif; ?>

            </div>

            
            <div>
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <ul class="list-unstyled m-0 p-0">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>

            
            <div>
                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul class="list-unstyled m-0 p-0">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>

     
            <div>
                <?php if(session('warning')): ?>
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <ul class="list-unstyled m-0 p-0">
                            <?php echo e(session('warning')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>




            <div class="col-md-8 mb-3">




                <div class="card">
                    <div class="card-header"><strong>Edit GRN Return</strong></div>
                    <div class="card-body">
                        <a class="btn btn btn-outline-info  mb-3" href="<?php echo e(url()->previous()); ?>"><i class="bi bi-skip-backward-circle pr-1"></i> Back</a>

                        
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Branch : </label>
                                <div class="col-sm-8">
                                    <select name="branch" id="branch" class="form-select" disabled>
                                        <option value="0">--Select One--</option>
                                        <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($branch->id); ?>"
                                                <?php echo e($branch->id == $grnReturn->branch_id ? 'selected' : ''); ?>><?php echo e($branch->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Date : </label>
                                <div class="col-sm-8">
                                    <input type="date" name="date" class="form-control" value="<?php echo e($grnReturn->date); ?>" disabled>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Vehicle Number : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="vehicle_number" class="form-control"
                                        value="<?php echo e($grnReturn->vehicle_number); ?>" disabled>
                                </div>
                            </div>

                               <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Person Name : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="person_name" class="form-control"
                                        value="<?php echo e($grnReturn->person_name); ?>" disabled>
                                </div>
                            </div>



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Note : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="note" id="" cols="30" rows="4" disabled><?php echo e($grnReturn->note); ?></textarea>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Status : </label>
                                <div class="col-sm-8">
                                    <select name="status" class="form-select" disabled>
                                        <option value="Processing" <?php echo e($grnReturn->status == 'Processing' ? 'selected' : ''); ?>>
                                            Processing
                                        </option>
                                        <option value="Complete" <?php echo e($grnReturn->status == 'Complete' ? 'selected' : ''); ?>>
                                            Complete</option>

                                    </select>
                                </div>
                            </div>


                            

                        
                    </div>


                </div>
            </div>

            <div class="col-md-4">
            </div>

        </div>


        <div class="row">
            <div class="md-8">
                <div class="card">
                    <div class="card-header"><strong>GRN Return Item List</strong></div>
                    <div class="card-body">


                        <div class="mt-3">
                            <table class="table table-hover table-responsive-lg" id="tbl-grn-item">
                                <thead class="thead-light">
                                    <tr>
                                        <th scope="col">#</th>
                                        <th>Code</th>
                                        <th>Name</th>
                                        <th>Unit Price</th>
                                     
                                        <th>Qty</th>
                                        <th>Total</th>
                                        

                                    </tr>
                                </thead>
                                <tbody>

                                    <?php
                                        $total = 0; // initialize total
                                    ?>

                                    <?php $__currentLoopData = $grnReturn->item; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e($loop->iteration); ?></th>
                                            <td><?php echo e($item->code); ?></td>
                                            <td><?php echo e($item->item->name); ?></td>
                                            <td><?php echo e(number_format($item->unit_price, 2)); ?></td>
                                          
                                            <td><?php echo e($item->qty); ?></td>
                                            <td><?php echo e(number_format($item->unit_price * $item->qty, 2)); ?></td>
                                            <td>
                                          
                                            </td>
                                        </tr>

                                        <?php
                                            $total += $item->unit_price * $item->qty;
                                        ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                            <div class="row">
                                <div class="col">
                                 
                                </div>
                                <div class="col">

                                    <div class="total_data">
                                        <div class="row g-3 d-flex justify-content-end">
                                            <div class="col-auto">
                                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                                    Amount</label>
                                            </div>
                                            <div class="col-auto">
                                                <input type="text" name="total"
                                                    class="form-control form-control-sm text-end fw-bold" readonly
                                                    value="<?php echo e(number_format($total, 2)); ?>" style="width: 120px;">
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>


                    </div>
                </div>
            </div>
            <div class="md-4"></div>
        </div>

    </div>





    </div>





<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        // header data edit confirmation
        //edit confirmation message
        $('#btn-header-data-edit').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to update GRN Return header data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, update it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });


        //grn complete validation
        $('#btn-complete-grn-return').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure complete GRN and tranfer item to stock ?",
                text: "after this you wont be update branch and GRN item again. please check and confirm it",
                icon: "info",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, complete the GRN !"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });


        // grn item remove validation
        $('.btn-grn-item-remove').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure remove grn item from grn product list ?",
                text: "this item is not added to stock yet.",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, remove it !"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });


 // this is typable selection box
        new TomSelect("#item", {
            create: false,
            searchHighlight: true,
            // placeholder: "Select Branch",

            sortField: {
                field: "text",
                direction: "asc",

            }
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\HirePurchasingManagementSolution\resources\views/grnReturn/view.blade.php ENDPATH**/ ?>