
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">








        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong><?php echo e(session('success')); ?></strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        <?php endif; ?>




        <div class="card">
            <div class="card-header"><strong><?php echo e($branch->name); ?> Stock Preview</strong></div>
            <div class="card-body">

               <a class="btn btn-outline-info mb-3"  href="<?php echo e(url()->previous()); ?>"><i class="bi bi-skip-backward-circle pr-1"></i>Back</a>


                <table class="table table-hover table-responsive-lg">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Name</th>
                            <th scope="col">Price Buy</th>
                            <th scope="col">Price Sell</th>
                            <th scope="col">Qty</th>
                            <th scope="col">Total Cost</th>
                            <th scope="col">Total Worth</th>

                        </tr>
                    </thead>
                    <tbody>

                        <?php
                            $total_qty = 0;
                            $total_cost = 0;
                            $total_worth = 0;
                        ?>

                        <?php $__currentLoopData = $stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($stock->item->code); ?></td>
                                <td><?php echo e($stock->item->name); ?></td>
                                <td><?php echo e(number_format($stock->price_buy, 2)); ?></td>
                                <td><?php echo e($stock->price_sell); ?></td>
                                <td><?php echo e($stock->qty); ?></td>
                                <td><?php echo e(number_format($stock->price_buy * $stock->qty,2)); ?></td>
                                <td><?php echo e(number_format($stock->price_sell * $stock->qty,2)); ?></td>

                                <?php
                                    $total_qty += $stock->qty;
                                    $total_worth += $stock->price_sell * $stock->qty;
                                    $total_cost += $stock->price_buy * $stock->qty;
                                ?>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>



                <div class="total_data">

                           <div class="row g-3 d-flex justify-content-end">
                                        <div class="col-auto">
                                            <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                                Qty</label>
                                        </div>
                                        <div class="col-auto">
                                            <input type="text" name="total"
                                                class="form-control form-control-sm text-end fw-bold" readonly
                                                value="<?php echo e($total_qty); ?>" style="width: 120px;">
                                        </div>

                                    </div>


                                      <div class="row g-3 d-flex justify-content-end pt-1">
                                        <div class="col-auto">
                                            <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                                Cost</label>
                                        </div>
                                        <div class="col-auto">
                                            <input type="text" name="total"
                                                class="form-control form-control-sm text-end fw-bold" readonly
                                                value="<?php echo e(number_format($total_cost, 2)); ?>" style="width: 120px;">
                                        </div>

                                    </div>


                                        <div class="row g-3 d-flex justify-content-end pt-1">
                                        <div class="col-auto">
                                            <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                                Worth</label>
                                        </div>
                                        <div class="col-auto">
                                            <input type="text" name="total"
                                                class="form-control form-control-sm text-end fw-bold" readonly
                                                value="<?php echo e(number_format($total_worth, 2)); ?>" style="width: 120px;">
                                        </div>

                                    </div>


                   


                </div>


            </div>
        </div>





    </div>



    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete item data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\HirePurchasingManagementSolution\resources\views/stocks/view.blade.php ENDPATH**/ ?>