
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">



        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        <?php endif; ?>





        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong><?php echo e(session('success')); ?></strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        <?php endif; ?>




        <div class="card">
            <div class="card-header"><strong>GRN Summery</strong></div>
            <div class="card-body">

                <a class="btn btn btn-outline-info  mb-3" href="<?php echo e(url()->previous()); ?>"><i
                        class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                


                <div class="row">


                    


                    <div class="col-md-6 col-lg-6"></div>
                </div>





                <table class="table table-hover table-responsive-lg fs-7">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Date</th>
                            <th scope="col">Branch</th>
                            <th scope="col">Vehicle Number</th>
                            <th scope="col">Total Item</th>
                            <th scope="col">Amount</th>
                            <th scope="col">Status</th>
                            <th scope="col">Action</th>

                        </tr>
                    </thead>
                    <tbody>

                        <?php
                            $total_grn = 0;
                            $total_grn_amount = 0;
                            $total_item = 0;

                        ?>

                        <?php if(isset($grns)): ?>
                            <?php $__currentLoopData = $grns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($grn->code); ?></td>
                                    <td><?php echo e($grn->date); ?></td>
                                    <td><?php echo e($grn->branch->name); ?></td>
                                    <td><?php echo e($grn->vehicle_number); ?></td>
                                    <td><?php echo e($grn->item_sum_qty); ?></td>
                                    <td><?php echo e(number_format($grn->total_amount, 2)); ?></td>

                                    <td><span
                                            class="badge rounded-pill <?php echo e($grn->status == 'Processing' ? 'bg-success' : 'bg-warning'); ?>  "><?php echo e($grn->status); ?></span>
                                    </td>

                                    <td><a href="<?php echo e(url('grn/view/' . $grn->id)); ?>" class="btn btn-sm btn-secondary"><i class="bi bi-eye pr-1"></i>View</a>
                                    </td>

                                    <?php
                                        $total_grn++;
                                        $total_grn_amount += $grn->total_amount;
                                        $total_item = $grn->item_sum_qty;
                                    ?>



                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>



                    </tbody>
                </table>


                <div class="paginate">
                    <?php echo e($grns->links()); ?>

                </div>

                <div class="row">
                    <div class="col-md-4">







                    </div>
                    <div class="col-md-4">
                        <div class="row g-3 d-flex justify-content-end">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    GRN</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="<?php echo e($total_grn); ?>" style="width: 120px;">
                            </div>

                        </div>




                    </div>
                    <div class="col-md-4">
                        <div class="row g-3 d-flex justify-content-end">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Item</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="<?php echo e($total_item); ?>" style="width: 120px;">
                            </div>

                        </div>

                        <div class="row g-3 d-flex justify-content-end pt-1">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Grn Amount</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="<?php echo e(number_format($total_grn_amount, 2)); ?>" style="width: 120px;">
                            </div>

                        </div>

                    </div>
                </div>

            </div>
        </div>





    </div>



    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete item data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\HirePurchasingManagementSolution\resources\views/reports/grnSummery.blade.php ENDPATH**/ ?>