
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">



        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        <?php endif; ?>





        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong><?php echo e(session('success')); ?></strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        <?php endif; ?>




        <div class="card">
            <div class="card-header"><strong>Invoice Return Summery</strong></div>
            <div class="card-body">

                <a class="btn btn btn-outline-info  mb-3" href="<?php echo e(url()->previous()); ?>"><i
                        class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                


                <div class="row">




                    <div class="col-md-6 col-lg-6"></div>
                </div>





                <table class="table table-hover table-responsive fs-7">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Date</th>
                            <th scope="col">Customer</th>
                            <th scope="col">NIC</th>
                            <th scope="col">Contact</th>
                            <th scope="col">Branch</th>
                            <th scope="col">Salesman</th>
                            <th scope="col">Item</th>
                            <th scope="col">Bill Type</th>
                            <th scope="col">Item Amount</th>
                            <th scope="col">Discount</th>
                            <th scope="col">Bill Amount</th>
                            <th scope="col">Paid</th>
                            <th scope="col">Not Paid</th>
                            <th scope="col">Status</th>
                            <th scope="col">Return Date</th>
                            <th scope="col">Return Amount</th>

                            <th scope="col">Action</th>

                        </tr>
                    </thead>
                    <tbody>

                        <?php
                            $total_invoice = 0;
                            $total_invoice_amount = 0;
                            $total_paid_amount = 0;
                            $total_not_paid_amount = 0;
                            $total_return_amount=0;
                        ?>

                        <?php if(isset($invoiceHasReturns)): ?>
                            <?php $__currentLoopData = $invoiceHasReturns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoiceHasReturn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $total_payment = 0;
                                ?>

                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($invoiceHasReturn->invoice->code); ?></td>
                                    <td><?php echo e($invoiceHasReturn->invoice->date); ?></td>
                                    <td><?php echo e($invoiceHasReturn->invoice->customer_name); ?></td>
                                    <td><?php echo e($invoiceHasReturn->invoice->customer_nic); ?></td>
                                    <td><?php echo e($invoiceHasReturn->invoice->customer_mobile . ' / ' . $invoiceHasReturn->invoice->customer_land); ?>

                                    </td>
                                    <td><?php echo e($invoiceHasReturn->invoice->branch->name); ?></td>
                                    <td><?php echo e($invoiceHasReturn->invoice->salesman->name); ?></td>
                                    <td><?php echo e($invoiceHasReturn->invoice->item->name); ?></td>
                                    <td><?php echo e($invoiceHasReturn->invoice->type); ?></td>
                                    <td><?php echo e(number_format($invoiceHasReturn->invoice->amount, 2)); ?></td>
                                    <td><?php echo e(number_format($invoiceHasReturn->invoice->discount, 2)); ?></td>

                                    
                                    <td><?php echo e(number_format($invoiceHasReturn->invoice->amount - $invoiceHasReturn->invoice->discount, 2)); ?>

                                    </td>
                                    <?php $__currentLoopData = $invoiceHasReturn->invoice->payment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $total_payment += $payment->amount; 
                                            $total_return_amount+=$payment->amount;
                                        ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <td><?php echo e(number_format($total_payment, 2)); ?></td>
                                    <td><?php echo e(number_format($invoiceHasReturn->invoice->amount - $invoiceHasReturn->invoice->discount - $total_payment, 2)); ?>

                                    </td>
                                    
                                    <td><span
                                            class="badge rounded-pill <?php echo e($invoiceHasReturn->invoice->status == 'Processing' ? 'bg-success' : 'bg-warning'); ?>  "><?php echo e($invoiceHasReturn->invoice->status); ?></span>
                                    </td>

                                    <td><?php echo e($invoiceHasReturn->date); ?></td>
                                    <td><?php echo e(number_format($invoiceHasReturn->amount,2)); ?></td>

                                    <td><a href="<?php echo e(url('invoice/view/' . $invoiceHasReturn->invoice->id)); ?>"
                                            class="btn btn-sm btn-primary"><i class="bi bi-eye pr-1"></i>View</td>

                                    <?php
                                        $total_invoice++;
                                        $total_invoice_amount +=
                                            $invoiceHasReturn->invoice->amount - $invoiceHasReturn->invoice->discount;
                                        $total_paid_amount = $invoiceHasReturn->invoice->payment_sum_amount;

                                    ?>



                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>



                    </tbody>
                </table>

                <div class="paginate">
                    <?php echo e($invoiceHasReturns->links()); ?>

                </div>

                <div class="row">
                    <div class="col-md-4">







                    </div>
                    <div class="col-md-4">
                        <div class="row g-3 d-flex justify-content-end">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Invoice</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="<?php echo e($total_invoice); ?>" style="width: 120px;">
                            </div>

                        </div>


                        <div class="row g-3 d-flex justify-content-end pt-1">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Invoice Amount</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="<?php echo e(number_format($total_invoice_amount, 2)); ?>" style="width: 120px;">
                            </div>

                        </div>

                    </div>
                    <div class="col-md-4">
                        <div class="row g-3 d-flex justify-content-end">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Paid Amount</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="<?php echo e(number_format($total_paid_amount, 2)); ?>" style="width: 120px;">
                            </div>

                        </div>


                        <div class="row g-3 d-flex justify-content-end pt-1">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Not Paid Amount</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="<?php echo e(number_format($total_invoice_amount - $total_paid_amount, 2)); ?>"
                                    style="width: 120px;">
                            </div>

                        </div>

                         <div class="row g-3 d-flex justify-content-end pt-1">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Return Amount</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="<?php echo e(number_format($total_return_amount, 2)); ?>"
                                    style="width: 120px;">
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>





    </div>



    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete item data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\HirePurchasingManagementSolution\resources\views/reports/invoiceReturnSummery.blade.php ENDPATH**/ ?>