
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">

        <div class="alert-section">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">

                    <ul class="list-unstyled m-0 p-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <?php echo e($error); ?>

                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                </div>
            <?php endif; ?>



            
            <?php if(session('error')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                </div>
            <?php endif; ?>


        </div>
        <form method="POST" action="<?php echo e(url('invoice/store')); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row">




                <div class="col-md-6">




                    <div class="card mb-3">
                        <div class="card-header"><strong>Customer Data</strong></div>
                        <div class="card-body">
                            <a class="btn btn btn-outline-info  mb-3" href="<?php echo e(url()->previous()); ?>"><i
                                    class="bi bi-skip-backward-circle pr-1"></i> Back</a>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Name : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="name" class="form-control">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">NIC : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="nic" class="form-control">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Mobile : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="mobile" class="form-control">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Land : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="land" class="form-control">
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Address : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="address" id="" cols="30" rows="4"></textarea>
                                </div>
                            </div>









                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label"> </label>
                                <div class="col-sm-8">
                                    <button class="btn btn-primary btn-block" type="submit">Save</button>
                                </div>
                            </div>



                        </div>
                    </div>



                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header"><strong>Invoice Data</strong></div>
                        <div class="card-body">


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Date : </label>
                                <div class="col-sm-8">
                                    <input type="date" name="date" class="form-control" value="<?php echo e(date('Y-m-d')); ?>">

                                </div>
                            </div>



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Salesman : </label>
                                <div class="col-sm-8">
                                    <select name="salesman" class="select-beast" id="salesman">
                                        <option value="0">Select Salesman</option>
                                        <?php $__currentLoopData = $salesmans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salesman): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($salesman->id); ?>"><?php echo e($salesman->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <input type="hidden" name="branch" value="<?php echo e($idBranch); ?>">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Item : </label>
                                <div class="col-sm-8">
                                    <select name="item" class="select-beast" id="item">
                                        <option value="0">Select Item</option>
                                        <?php $__currentLoopData = $stockItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stockItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($stockItem->qty > 0): ?>
                                                <option value="<?php echo e($stockItem->id); ?>">
                                                    <?php echo e($stockItem->item->name . ' / ' . number_format($stockItem->price_sell, 2) . ' / ' . $stockItem->qty); ?>

                                                </option>
                                            <?php else: ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Bill Type : </label>
                                <div class="col-sm-8">
                                    <select name="billType" class="form-control" id="bill_type">
                                        <option value="Installment">Installment</option>
                                        <option value="Cash">Cash</option>
                                    </select>
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Amount : </label>
                                <div class="col-sm-8">
                                    <input type="double" name="amount" class="form-control">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Discount : </label>
                                <div class="col-sm-8">
                                    <input type="double" name="discount" class="form-control">
                                </div>
                            </div>


                            <div class="form-group row" id="div_down_payment">
                                <label for="name" class="col-sm-4 col-form-label">Down Payment : </label>
                                <div class="col-sm-8">
                                    <input type="double" name="down_payment" class="form-control" id="down_payment">
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Note : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="note" id="" cols="30" rows="4"></textarea>
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Picture : </label>
                                <div class="col-sm-8">
                                    <input class="form-control" type="file" name="picture" id="picture">
                                    <img class="img img-thumbnail mt-3" id="picture_preview"
                                        src="<?php echo e(asset('storage/images/default/sample-image-document.jpg')); ?>"
                                        alt="" width="200" height="200">
                                </div>
                            </div>





                        </div>
                    </div>


                </div>


            </div>

        </form>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        // document 6 before upload
        document.getElementById('picture').addEventListener('change', function(event) {
            const file = event.target.files[0];
            if (file) {
                const preview = document.getElementById('picture_preview');
                preview.src = URL.createObjectURL(file);
                preview.style.display = "block";
            }
        });

        // this is typable selection box
        new TomSelect("#item", {
            create: false,
            searchHighlight: true,
            // placeholder: "Select Branch",

            sortField: {
                field: "text",
                direction: "asc",

            }
        });

        new TomSelect("#salesman", {
            create: false,
            searchHighlight: true,
            // placeholder: "Select Branch",
            sortField: {
                field: "text",
                direction: "asc",

            }
        });

        //visible down payment field
        $('#bill_type').on('change', function() {
            let value = $(this).val();

            if (value == 'Cash') {
                $('#div_down_payment').hide();
            } else if (value == 'Installment') {
                $('#div_down_payment').show();
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\HirePurchasingManagementSolution\resources\views/invoice/new.blade.php ENDPATH**/ ?>