
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">



        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        <?php endif; ?>





        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong><?php echo e(session('success')); ?></strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        <?php endif; ?>




        <div class="card">
            <div class="card-header"><strong>GRN Return List</strong></div>
            <div class="card-body">

                <a class="btn btn btn-outline-info  mb-3" href="<?php echo e(url()->previous()); ?>"><i
                        class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                <a class="btn btn-success mb-3" href="<?php echo e(url('grnReturn/create')); ?>"><i
                        class="bi bi-plus-circle pr-1"></i>Create</a>




                <table class="table table-hover table-responsive-lg">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Branch</th>
                            <th scope="col">Vehicle Number</th>
                            <th scope="col">Person Name</th>
                            <th scope="col">Status</th>
                            <th scope="col">Date</th>
                             <th scope="col">Total Item</th>
                              <th scope="col">Total Amount</th>
                            <th scope="col">Action</th>

                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $grnReturns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grnReturn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($grnReturn->code); ?></td>
                                <td><?php echo e($grnReturn->branch->name); ?></td>
                                <td><?php echo e($grnReturn->vehicle_number); ?></td>
                                  <td><?php echo e($grnReturn->person_name); ?></td>
                                <td><span
                                        class="badge rounded-pill <?php echo e($grnReturn->status == 'Processing' ? 'bg-primary' : 'bg-warning'); ?>  "><?php echo e($grnReturn->status); ?></span>
                                </td>
                                <td><?php echo e($grnReturn->date); ?></td>
                                 <td><?php echo e($grnReturn->item_sum_qty); ?></td>
                                  <td><?php echo e(number_format($grnReturn->total_sum,2)); ?></td>

                                <td>
                                    <div class="d-flex gap-1">
                                        <a href="<?php echo e(url('grnReturn/view/' . $grnReturn->id)); ?>"
                                            class="btn btn btn-primary btn-sm"><i class="bi bi-eye pr-1"></i>View</a>
                                        <a href="<?php echo e(url('grnReturn/edit/' . $grnReturn->id)); ?>"
                                            class="btn btn btn-warning btn-sm"><i class="bi bi-pencil pr-1"></i>Update</a>
                                        

                                    </div>

                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>





    </div>



    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\HirePurchasingManagementSolution\resources\views/grnReturn/all.blade.php ENDPATH**/ ?>