
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">



        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        <?php endif; ?>





        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong><?php echo e(session('success')); ?></strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        <?php endif; ?>




        <div class="card">
            <div class="card-header"><strong>Invoice Summery</strong></div>
            <div class="card-body">

                <a class="btn btn btn-outline-info  mb-3" href="<?php echo e(url()->previous()); ?>"><i
                        class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                


                <div class="row">


                    


                    <div class="col-md-6 col-lg-6"></div>
                </div>





                <table class="table table-hover table-responsive fs-7">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Date</th>
                            <th scope="col">Customer</th>
                            <th scope="col">NIC</th>
                            <th scope="col">Contact</th>
                            <th scope="col">Branch</th>
                            <th scope="col">Salesman</th>
                            <th scope="col">Item</th>
                            <th scope="col">Bill Type</th>
                            <th scope="col">Item Amount</th>
                            <th scope="col">Discount</th>
                            <th scope="col">Bill Amount</th>
                            <th scope="col">Paid</th>
                            <th scope="col">Not Paid</th>
                            <th scope="col">Status</th>

                            <th scope="col">Action</th>

                        </tr>
                    </thead>
                    <tbody>

                        <?php
                            $total_invoice = 0;
                            $total_invoice_amount = 0;
                            $total_paid_amount = 0;
                            $total_not_paid_amount = 0;
                        ?>

                        <?php if(isset($invoices)): ?>
                            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($invoice->code); ?></td>
                                    <td><?php echo e($invoice->date); ?></td>
                                    <td><?php echo e($invoice->customer_name); ?></td>
                                    <td><?php echo e($invoice->customer_nic); ?></td>
                                    <td><?php echo e($invoice->customer_mobile . ' / ' . $invoice->customer_land); ?></td>
                                    <td><?php echo e($invoice->branch->name); ?></td>
                                    <td><?php echo e($invoice->salesman->name); ?></td>
                                    <td><?php echo e($invoice->item->name); ?></td>
                                    <td><?php echo e($invoice->type); ?></td>
                                    <td><?php echo e(number_format($invoice->amount, 2)); ?></td>
                                    <td><?php echo e(number_format($invoice->discount, 2)); ?></td>
                                    <td><?php echo e(number_format($invoice->amount - $invoice->discount, 2)); ?></td>
                                    <td><?php echo e(number_format($invoice->payment_sum_amount, 2)); ?></td>
                                    <td><?php echo e(number_format($invoice->amount - $invoice->discount - $invoice->payment_sum_amount, 2)); ?>

                                    </td>
                                    
                                    <td><span
                                            class="badge rounded-pill <?php echo e($invoice->status == 'Processing' ? 'bg-success' : 'bg-warning'); ?>  "><?php echo e($invoice->status); ?></span>
                                    </td>

                                    <td><a href="<?php echo e(url('invoice/view/' . $invoice->id)); ?>"
                                            class="btn btn-sm btn-primary"><i class="bi bi-eye pr-1"></i>View</td>

                                    <?php
                                        $total_invoice++;
                                        $total_invoice_amount += $invoice->amount - $invoice->discount;
                                        $total_paid_amount = $invoice->payment_sum_amount;

                                    ?>

                                

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>



                    </tbody>
                </table>

<div class="paginate">
    <?php echo e($invoices->links()); ?>

</div>

                <div class="row">
                    <div class="col-md-4">







                    </div>
                    <div class="col-md-4">
                        <div class="row g-3 d-flex justify-content-end">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Invoice</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="<?php echo e($total_invoice); ?>" style="width: 120px;">
                            </div>

                        </div>


                        <div class="row g-3 d-flex justify-content-end pt-1">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Invoice Amount</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="<?php echo e(number_format($total_invoice_amount, 2)); ?>" style="width: 120px;">
                            </div>

                        </div>

                    </div>
                    <div class="col-md-4">
                        <div class="row g-3 d-flex justify-content-end">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Paid Amount</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="<?php echo e(number_format($total_paid_amount, 2)); ?>" style="width: 120px;">
                            </div>

                        </div>


                        <div class="row g-3 d-flex justify-content-end pt-1">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Not Paid Amount</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="<?php echo e(number_format($total_invoice_amount - $total_paid_amount, 2)); ?>"
                                    style="width: 120px;">
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>





    </div>



    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete item data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\HirePurchasingManagementSolution\resources\views/reports/invoiceSummery.blade.php ENDPATH**/ ?>