
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">








        <?php if(session('success')): ?>
            <div class="alert alert-success" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong><?php echo e(session('success')); ?></strong>
                </ul>
            </div>
        <?php endif; ?>




        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header"><strong>Stock List</strong></div>
                    <div class="card-body">

                        <a class="btn btn-outline-info mb-3" href="<?php echo e(url()->previous()); ?>"><i
                                class="bi bi-skip-backward-circle pr-1"></i>Back</a>

                        <table class="table table-hover table-responsive-lg">
                            <thead class="thead-light">
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Code</th>
                                    <th scope="col">Name</th>
                                    <th scope="col">Total Item</th>
                                    <th scope="col">Total Worth</th>
                                    <th scope="col">Action</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($branch->code); ?></td>
                                        <td><?php echo e($branch->name); ?></td>
                                        <td><?php echo e($branch->stock_sum_qty); ?></td>
                                        <td><?php echo e(number_format($branch->total_sum,2)); ?></td>

                                        <td>
                                            <div class="d-flex gap-1">
                                                <a href="<?php echo e(url('stocks/view/' . $branch->id)); ?>"
                                                    class="btn btn-primary btn-sm"><i class="bi bi-eye pr-1"></i>View</a>
                                            </div>

                                        </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>

                        <div class="pagination">
                            <?php echo e($branches->links()); ?>

                        </div>
                    </div>
                </div>

            </div>
            <div class="col-md-4"> </div>
        </div>





    </div>



    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete branch data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\HirePurchasingManagementSolution\resources\views/stocks/all.blade.php ENDPATH**/ ?>