 
 <?php $__env->startSection('style'); ?>
 <?php $__env->stopSection(); ?>

 <?php $__env->startSection('content'); ?>
     <div class="container">

         <div class="alert-section">
             <?php if($errors->any()): ?>
                 <div class="alert alert-danger alert-dismissible fade show" role="alert">

                     <ul class="list-unstyled m-0 p-0">
                         <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             <li>
                                 <?php echo e($error); ?>

                             </li>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                     </ul>
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                         <span aria-hidden="true">&times;</span></button>
                 </div>
             <?php endif; ?>



             
             <?php if(session('error')): ?>
                 <div class="alert alert-error alert-dismissible fade show" role="alert">
                     <?php echo e(session('error')); ?>

                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                         <span aria-hidden="true">&times;</span></button>
                 </div>
             <?php endif; ?>


             
             <?php if(session('success')): ?>
                 <div class="alert alert-success alert-dismissible fade show" role="alert">
                     <?php echo e(session('success')); ?>

                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                         <span aria-hidden="true">&times;</span></button>
                 </div>
             <?php endif; ?>



             <?php if(session('warning')): ?>
                 <div class="alert alert-success alert-dismissible fade show" role="alert">
                     <?php echo e(session('warning')); ?>

                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                         <span aria-hidden="true">&times;</span></button>
                 </div>
             <?php endif; ?>


         </div>

         <?php echo csrf_field(); ?>
         <div class="invoice-list">








             <div class="card mb-3">
                 <div class="card-header"><strong>Invoice List</strong></div>
                 <div class="card-body">
                     <a class="btn btn btn-outline-info  mb-3" href="<?php echo e(url()->previous()); ?>"><i
                             class="bi bi-skip-backward-circle pr-1"></i> Back</a>


                     <form method="GET"
                         action="<?php echo e(url('invoice/getInvoiceDataByNameOrNicOrBillNumberOrContacts/' . $idBranch)); ?>">
                         <?php echo csrf_field(); ?>

                         <div class="row">
                             <div class="col"></div>

                             <div class="col">
                                 <div class="d-flex align-items-center gap-2 mb-2">
                                     <input type="text" class="form-control" name="query_type"
                                         placeholder="Name / Bill No / NIC ">
                                     <button type="submit" class="btn btn-primary mt-1">Search</button>

                                 </div>

                             </div>
                         </div>



                     </form>






                     <table class="table table-hover table-responsive-lg">
                         <thead>
                             <tr>
                                 <th scope="col">#</th>
                                 <th scope="col">Date</th>
                                 <th scope="col">Code</th>
                                 <th scope="col">Customer Name</th>
                                 <th scope="col">NIC</th>
                                 <th scope="col">Salesman</th>
                                 <th scope="col">Item</th>
                                 <th scope="col">Status</th>
                                 <th scope="col">Bill Amount</th>
                                 <th scope="col">Paid</th>
                                 <th scope="col">Not Paid</th>
                                 <th scope="col">Payment</th>
                                 <th scope="col">Action</th>
                             </tr>
                         </thead>
                         <tbody>

                             <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                 <tr>
                                     <th><?php echo e($loop->iteration); ?></th>
                                     <td><?php echo e($invoice->date); ?></td>
                                     <td><?php echo e($invoice->code); ?></td>
                                     <td><?php echo e($invoice->customer_name); ?></td>
                                     <td><?php echo e($invoice->customer_nic); ?></td>
                                     <td><?php echo e($invoice->salesman->name); ?></td>
                                     <td><?php echo e($invoice->item->name); ?></td>
                                     <td>

                                         <?php if($invoice->status == 'Processing'): ?>
                                             <span class="badge badge-pill badge-primary p-1"><?php echo e($invoice->status); ?></span>
                                         <?php elseif($invoice->status == 'Complete'): ?>
                                             <span class="badge badge-pill badge-success p-1"><?php echo e($invoice->status); ?></span>
                                         <?php endif; ?>
                                     </td>


                                     <td class="text-end"><?php echo e(number_format($invoice->amount, 2)); ?></td>
                                     <td class="text-end"><?php echo e(number_format($invoice->payment_sum_amount, 2)); ?></td>
                                     <td class="text-end">
                                         <?php echo e(number_format($invoice->amount - $invoice->payment_sum_amount, 2)); ?></td>


                                     <td>
                                         <form action="<?php echo e(url('payment/create/' . $invoice->id)); ?>" method="POST">
                                             <?php echo csrf_field(); ?>
                                             <input type="number" class="form-control form-control-sm" name="payment">

                                     </td>

                                     <td>
                                         <div class="d-flex align-items-center gap-1"> <button type="submit"
                                                 class="btn btn-success btn-sm"><i class="bi bi-cash-coin"></i></button>
                                             </form>



                                             <a href="<?php echo e(url('invoice/view/' . $invoice->id)); ?>"
                                                 class="btn btn-sm btn-info"><i class="bi bi-eye"></i></a>
                                     </td>
                 </div>


                 </tr>
                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                 </tbody>
                 </table>












                 



             </div>
         </div>






     </div>

     <div class="todayPaymentData">

         <div class="card">
             <div class="card-header">Payment Data</div>
             <div class="card-body">
                 <table class="table table-hover table-responsive-lg">
                     <thead>
                         <tr>
                             <th scope="col">#</th>
                             <th scope="col">Code</th>
                             <th scope="col">Date</th>
                             <th scope="col">Invoice Code</th>
                             <th scope="col">Customer</th>
                             <th scope="col">Type</th>
                             <th scope="col">Amount</th>
                             <th scope="col">Action</th>
                         </tr>
                     </thead>
                     <tbody>

                         <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             <tr>
                                 <th scope="row"><?php echo e($loop->iteration); ?></th>
                                 <td><?php echo e($payment->code); ?></td>
                                 <td><?php echo e($payment->date); ?></td>
                                 <td><?php echo e($payment->invoice->code); ?></td>
                                 <td><?php echo e($payment->invoice->customer_name); ?></td>
                                 <td><?php echo e($payment->type); ?></td>
                                 <td><?php echo e(number_format($payment->amount, 2)); ?></td>
                                 <td>
                                     <form action="<?php echo e(url('payment/delete/' . $payment->id)); ?>" method="POST">
                                         <?php echo csrf_field(); ?>
                                         <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-outline-danger btn-delete"><i class="bi bi-trash3"></i></button>
                                     </form>
                                 </td>
                             </tr>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                     </tbody>
                 </table>
             </div>
         </div>


     </div>



     </div>
 <?php $__env->stopSection(); ?>

 <?php $__env->startSection('script'); ?>
     <script>
         // document 6 before upload
         // document.getElementById('picture').addEventListener('change', function(event) {
         //     const file = event.target.files[0];
         //     if (file) {
         //         const preview = document.getElementById('picture_preview');
         //         preview.src = URL.createObjectURL(file);
         //         preview.style.display = "block";
         //     }
         // });

         // this is typable selection box
         // new TomSelect("#item", {
         //     create: false,
         //     searchHighlight: true,
         //     // placeholder: "Select Branch",

         //     sortField: {
         //         field: "text",
         //         direction: "asc",

         //     }
         // });

         // new TomSelect("#invoice_list", {
         //     create: false,
         //     searchHighlight: true,
         //     // placeholder: "Select Branch",
         //     sortField: {
         //         field: "text",
         //         direction: "asc",

         //     }
         // });

         //visible down payment field
         // $('#bill_type').on('change', function() {
         //     let value = $(this).val();

         //     if (value == 'Cash') {
         //         $('#div_down_payment').hide();
         //     } else if (value == 'Installment') {
         //         $('#div_down_payment').show();
         //     }
         // });


         //delete confirmation message
         $('.btn-delete').click(function(e) {
             e.preventDefault();
             var form = $(this).parents('form');
             //alert('aaa');
             Swal.fire({
                 title: "Are you sure to delete payment data ?",
                 text: "You won't be able to revert this!",
                 icon: "warning",
                 showCancelButton: true,
                 confirmButtonColor: "#3085d6",
                 cancelButtonColor: "#d33",
                 confirmButtonText: "Yes, delete it!"
             }).then((result) => {
                 if (result.isConfirmed) {
                     // Swal.fire({
                     //   title: "Deleted!",
                     //   text: "Your file has been deleted.",
                     //   icon: "success"
                     // });
                     form.submit();
                 }
             });

         });
     </script>
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('template.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\HirePurchasingManagementSolution\resources\views/payment/all.blade.php ENDPATH**/ ?>