
<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">







        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">

                <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
            </div>
        <?php endif; ?>


         <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">

                <?php echo e(session('error')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
            </div>
        <?php endif; ?>

          <?php if(session('warning')): ?>
            <div class="alert alert-warning alert-dismissible fade show" role="alert">

                <?php echo e(session('warning')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
            </div>
        <?php endif; ?>




        <div>

            <div class="card">
                <div class="card-header"><strong>Invoice List</strong></div>
                <div class="card-body">
                    <a class="btn btn btn-outline-info  mb-3" href="<?php echo e(url()->previous()); ?>"><i
                            class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                    <a class="btn btn-success mb-3" href="<?php echo e(url('invoice/create/' . $idBranch)); ?>"><i
                            class="bi bi-plus-circle pr-1"></i>Create</a>

                    <table class="table table-hover table-responsive fs-7">
                        <tbody>
                            <thead class="thead-light">



                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Code</th>
                                    <th scope="col">Date</th>
                                    <th scope="col">Salesman</th>
                                    <th scope="col">Customer Name</th>
                                    <th scope="col">Bill Ttype</th>
                                    <th scope="col">Item Name</th>
                                    <th scope="col">Item Amount</th>
                                    <th scope="col">Discount</th>
                                    <th scope="col">Bill Amount</th>
                                    <th scope="col">Paid Amount</th>
                                    <th scope="col">Not Amount</th>
                                    <th scope="col">Status</th>
                                    <th scope="col">Action</th>

                                </tr>
                            </thead>
                        <tbody>
                            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($invoice->code); ?></td>
                                    <td><?php echo e($invoice->date); ?></td>
                                    <td><?php echo e($invoice->salesman->name); ?></td>
                                    <td><?php echo e($invoice->customer_name); ?></td>


                                    <td><?php echo e($invoice->type); ?></td>
                                    <td><?php echo e($invoice->item->name); ?></td>
                                    <td><?php echo e(number_format($invoice->amount, 2)); ?></td>
                                    <td><?php echo e(number_format($invoice->discount, 2)); ?></td>
                                    <td><?php echo e(number_format($invoice->amount - $invoice->discount, 2)); ?></td>
                                    <td><?php echo e(number_format($invoice->payment_sum_amount, 2)); ?></td>
                                    <td><?php echo e(number_format($invoice->amount - $invoice->discount - $invoice->payment_sum_amount, 2)); ?>

                                    </td>
                                    <td>

                                        <?php if($invoice->status == 'Complete'): ?>
                                            <span class="badge rounded-pill bg-info p-1"><?php echo e($invoice->status); ?></span>
                                        <?php elseif($invoice->status == 'Processing'): ?>
                                            <span class="badge rounded-pill bg-success p-1"><?php echo e($invoice->status); ?></span>
                                        <?php endif; ?>

                                    </td>

                                    <td>
                                        <div class="d-flex gap-1">
                                            <a href="<?php echo e(url('invoice/view/' . $invoice->id)); ?>"
                                                class="btn btn btn-primary btn-sm" data-bs-toggle="tooltip"
                                                title="View Invoice"><i class="bi bi-eye pr-1"></i>View</a>

                                            <a href="<?php echo e(url('invoice/edit/' . $invoice->id)); ?>"
                                                class="btn btn btn-warning btn-sm"><i class="bi bi-pencil pr-1"
                                                    data-bs-toggle="tooltip" title="Edit Invoice"></i>Update</a>

                                     

                                        </div>



                                    </td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                    <div class="pagination">
                        <?php echo e($invoices->links()); ?>

                    </div>
                </div>
            </div>




        </div>




    </div>



    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
    
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\HirePurchasingManagementSolution\resources\views/invoice/all.blade.php ENDPATH**/ ?>