<?php

use App\Http\Controllers\BranchController;
use App\Http\Controllers\GrnController;
use App\Http\Controllers\GrnHasItemController;
use App\Http\Controllers\GrnReturnController;
use App\Http\Controllers\GrnReturnHasItemController;
use App\Http\Controllers\GrnReturnHasItemHasStockController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\InvoiceHasCancelController;
use App\Http\Controllers\InvoiceHasReturnController;
use App\Http\Controllers\ItemController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\SalesmanController;
use App\Http\Controllers\StockController;
use App\Models\branch;
use App\Models\GrnHasItem;
use App\Models\InvoiceHasCancel;
use App\Models\Payment;
use Illuminate\Routing\Route as RoutingRoute;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('dashboard');
});

// branch routes
Route::get('branch/create', [BranchController::class, 'create']);
Route::post('branch/store', [BranchController::class, 'store']);
Route::get('branch/all', [BranchController::class, 'index']);
Route::get('branch/view/{id}', [BranchController::class, 'show']);
Route::get('branch/edit/{id}', [BranchController::class, 'edit']);
Route::put('branch/update/{id}', [BranchController::class, 'update']);
Route::delete('branch/delete/{id}', [BranchController::class, 'destroy']);

//item routs
Route::get('item/all', [ItemController::class, 'index']);
Route::get('item/create', [ItemController::class, 'create']);
Route::post('item/store', [ItemController::class, 'store']);
Route::get('item/view/{id}', [ItemController::class, 'show']);
Route::get('item/edit/{id}', [ItemController::class, 'edit']);
Route::put('item/update/{id}', [ItemController::class, 'update']);
Route::delete('item/delete/{id}', [ItemController::class, 'destroy']);


//salesman routs
Route::get('salesman/create', [SalesmanController::class, 'create']);
Route::post('salesman/store', [SalesmanController::class, 'store']);
Route::get('salesman/all', [SalesmanController::class, 'index']);
Route::get('salesman/view/{id}', [SalesmanController::class, 'show']);
Route::get('salesman/edit/{id}', [SalesmanController::class, 'edit']);
Route::put('salesman/update/{id}', [SalesmanController::class, 'update']);
Route::delete('salesman/delete/{id}', [SalesmanController::class, 'destroy']);

// grn routes
Route::get('grn/all', [GrnController::class, 'index']);
Route::get('grn/view/{id}', [GrnController::class, 'show']);
Route::get('grn/create', [GrnController::class, 'create']);
Route::post('grn/store', [GrnController::class, 'store']);
Route::get('grn/edit/{id}', [GrnController::class, 'edit']);
Route::put('grn/update/{id}', [GrnController::class, 'update']);
Route::delete('grn/delete/{id}', [GrnController::class, 'destroy']);

//grn item routs
Route::post('grnHasItem/store/{id}', [GrnHasItemController::class, 'store']);
Route::delete('grnHasItem/delete/{id}', [GrnHasItemController::class, 'destroy']);


//stock routs
Route::post('stocks/store/{id}', [StockController::class, 'store']);
Route::get('stocks/all', [StockController::class, 'index']);
Route::get('stocks/view/{id}', [StockController::class, 'show']);


//invoice routes
Route::get('invoice/all/{idBranch}', [InvoiceController::class, 'index']);
Route::get('invoice/selectBranch', [InvoiceController::class, 'selectBranch']);
Route::get('invoice/create/{id}', [InvoiceController::class, 'create']);
Route::post('invoice/store', [InvoiceController::class, 'store']);
Route::get('invoice/edit/{id}', [InvoiceController::class, 'edit']);
Route::put('invoice/update/{id}', [InvoiceController::class, 'update']);
Route::get('invoice/view/{id}', [InvoiceController::class, 'show']);
Route::get('invoice/getInvoiceDataByNameOrNicOrBillNumberOrContacts/{id}', [InvoiceController::class, 'getInvoiceDataByCustomerNameOrNicOrContactOrBillNumber']);
Route::get('invoice/test/{id}', [InvoiceController::class, 'testFunction']);
Route::delete('invoice/delete/{id}',[InvoiceController::class,'destroy']);


//payment routs
Route::get('payment/all/{idBranch}', [PaymentController::class, 'index']);
//Route::get('payment/find/{idBranch}', [PaymentController::class, 'paymentAll']);
//Route::get('payment/test/{id}',[PaymentController::class,'testFunction']);
Route::post('payment/create/{id}', [PaymentController::class, 'store']);
Route::delete('payment/delete/{id}', [PaymentController::class, 'destroy']);

// invoice has cancel routes
Route::post('invoiceHasCancel/create/{id}', [InvoiceHasCancelController::class, 'store']);
Route::delete('invoiceHasCancel/delete/{id}', [InvoiceHasCancelController::class, 'destroy']);

//invoice has return routes
Route::post('invoiceHasReturn/create/{id}', [InvoiceHasReturnController::class, 'store']);
Route::delete('invoiceHasReturn/delete/{id}',[InvoiceHasReturnController::class,'destroy']);

//grn return routs
Route::get('grnReturn/view/{id}',[GrnReturnController::class,'show']);
Route::get('grnReturn/create', [GrnReturnController::class, 'create']);
Route::post('grnReturn/store', [GrnReturnController::class, 'store']);
Route::get('grnReturn/all', [GrnReturnController::class, 'index']);
Route::get('grnReturn/edit/{id}', [GrnReturnController::class, 'edit']);
Route::put('grnReturn/update/{id}', [GrnReturnController::class, 'update']);
Route::delete('grnReturn/delete/{id}',[GrnReturnController::class,'destroy']);

//grn return has item routs
Route::post('grnReturnHasItem/store/{id}', [GrnReturnHasItemController::class, 'store']);
Route::delete('grnReturnHasItem/delete/{id}',[GrnReturnHasItemController::class,'destroy']);

//grn return has item has stock routes
Route::post('grnReturnHasItemHasStock/store/{id}',[GrnReturnHasItemHasStockController::class,'store']);

//reports routs
Route::get('reports/invoiceSummery',[InvoiceController::class,'invoiceSummery']);
Route::get('reports/invoiceSummery/search',[InvoiceController::class,'invoiceSummerySearch']);
Route::get('reports/grnSummery',[GrnController::class,'grnSummery']);
Route::get('reports/grnReturnSummery',[GrnReturnController::class,'grnReturnSummery']);
Route::get('reports/paymentSummery',[PaymentController::class,'paymentSummery']);
Route::get('reports/invoiceReturnSummery',[InvoiceHasReturnController::class,'invoiceHasReturnSummery']);
Route::get('reports/invoiceCancelSummery',[InvoiceHasCancelController::class,'invoiceHasCancelSummery']);

