@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">








        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong>{{ session('success') }}</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        @endif




        <div class="card">
            <div class="card-header"><strong>{{ $branch->name }} Stock Preview</strong></div>
            <div class="card-body">

               <a class="btn btn-outline-info mb-3"  href="{{ url()->previous() }}"><i class="bi bi-skip-backward-circle pr-1"></i>Back</a>


                <table class="table table-hover table-responsive-lg">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Name</th>
                            <th scope="col">Price Buy</th>
                            <th scope="col">Price Sell</th>
                            <th scope="col">Qty</th>
                            <th scope="col">Total Cost</th>
                            <th scope="col">Total Worth</th>

                        </tr>
                    </thead>
                    <tbody>

                        @php
                            $total_qty = 0;
                            $total_cost = 0;
                            $total_worth = 0;
                        @endphp

                        @foreach ($stocks as $stock)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $stock->item->code }}</td>
                                <td>{{ $stock->item->name }}</td>
                                <td>{{ number_format($stock->price_buy, 2) }}</td>
                                <td>{{ $stock->price_sell }}</td>
                                <td>{{ $stock->qty }}</td>
                                <td>{{ number_format($stock->price_buy * $stock->qty,2) }}</td>
                                <td>{{ number_format($stock->price_sell * $stock->qty,2) }}</td>

                                @php
                                    $total_qty += $stock->qty;
                                    $total_worth += $stock->price_sell * $stock->qty;
                                    $total_cost += $stock->price_buy * $stock->qty;
                                @endphp

                            </tr>
                        @endforeach

                    </tbody>
                </table>



                <div class="total_data">

                           <div class="row g-3 d-flex justify-content-end">
                                        <div class="col-auto">
                                            <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                                Qty</label>
                                        </div>
                                        <div class="col-auto">
                                            <input type="text" name="total"
                                                class="form-control form-control-sm text-end fw-bold" readonly
                                                value="{{ $total_qty }}" style="width: 120px;">
                                        </div>

                                    </div>


                                      <div class="row g-3 d-flex justify-content-end pt-1">
                                        <div class="col-auto">
                                            <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                                Cost</label>
                                        </div>
                                        <div class="col-auto">
                                            <input type="text" name="total"
                                                class="form-control form-control-sm text-end fw-bold" readonly
                                                value="{{ number_format($total_cost, 2) }}" style="width: 120px;">
                                        </div>

                                    </div>


                                        <div class="row g-3 d-flex justify-content-end pt-1">
                                        <div class="col-auto">
                                            <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                                Worth</label>
                                        </div>
                                        <div class="col-auto">
                                            <input type="text" name="total"
                                                class="form-control form-control-sm text-end fw-bold" readonly
                                                value="{{ number_format($total_worth, 2) }}" style="width: 120px;">
                                        </div>

                                    </div>


                   


                </div>


            </div>
        </div>





    </div>



    </div>
@endsection

@section('script')
    <script>
        //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete item data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });
    </script>
@endsection
