@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">


        <div class="row">




            <div class="col-md-8">

                <div class="card">
                    <div class="card-header"><strong>View Salesman</strong></div>
                    <div class="card-body">
                       <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                        <form method="POST" action="{{ url('salesman/store') }}" enctype="multipart/form-data">
                            @csrf

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Branch : </label>
                                <div class="col-sm-8">
                                    <select name="branch" class="form-select" disabled>
                                        <option value="0">--Select One--</option>
                                        @foreach ($branches as $branch)
                                            {{-- <option value="{{ $branch->id }}">{{ $branch->name }}</option> --}}
                                            <option value="{{ $branch->id }}"
                                                {{ $salesman->branch_id == $branch->id ? 'selected' : '' }}>
                                                {{ $branch->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Name : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="name" class="form-control" value="{{ $salesman->name }}"
                                        readonly>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">NIC : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="nic" class="form-control" value="{{ $salesman->nic }}"
                                        readonly>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label" readonly>Date of Birth : </label>
                                <div class="col-sm-8">
                                    <input type="date" name="dob" class="form-control" value="{{ $salesman->dob }}"
                                        readonly>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label" readonly>Email : </label>
                                <div class="col-sm-8">
                                    <input type="email" name="email" class="form-control"
                                        value="{{ $salesman->email }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label" readonly>Mobile : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="mobile" class="form-control"
                                        value="{{ $salesman->email }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label" readonly>Land : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="land" class="form-control"
                                        value="{{ $salesman->land }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label" readonly>Address : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="address" id="" cols="30" rows="4">{{ $salesman->address }}</textarea>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label" readonly>Note : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="note" id="" cols="30" rows="4">{{ $salesman->note }} </textarea>
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Picture : </label>
                                <div class="col-sm-8">

                                    <img class="img img-thumbnail mt-3" id="picture_preview"
                                        src="{{ $salesman->profile_picture_name == '' || $salesman->profile_picture_name == null ? asset('storage/images/default/sample-image-profile.jpg') : asset('storage/' . $salesman->profile_picture_name) }}"
                                        alt="" width="150" height="150">
                                </div>
                            </div>



                            <div class="form-group row">

                                @if (count($salesman->images) > 0)
                                    <label for="name" class="col-sm-4 col-form-label">Documents : </label>
                                    <div class="col-sm-4">

                                        <img class="img img-thumbnail mt-3" id="document_1_preview"
                                            src="{{ asset('storage/' . $salesman->images[0]->image_name) }}"
                                            alt="" width="150" height="150">
                                    </div>
                                @endif



                                <div class="col-sm-4">

                                    @if (count($salesman->images) > 1)
                                        <img class="img img-thumbnail mt-3" id="document_2_preview"
                                            src="{{ asset('storage/' . $salesman->images[1]->image_name) }}"
                                            alt="" alt="" width="150" height="150">
                                    @endif



                                </div>
                            </div>



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label"> </label>
                                <div class="col-sm-8">
                                    <button class="btn btn-primary btn-block" type="submit">Save</button>
                                </div>
                            </div>


                        </form>
                    </div>
                </div>



            </div>
            <div class="col-md-4"></div>
        </div>



    </div>
@endsection

@section('script')
    <script>
        // document 6 before upload
        document.getElementById('picture').addEventListener('change', function(event) {
            const file = event.target.files[0];
            if (file) {
                const preview = document.getElementById('picture_preview');
                preview.src = URL.createObjectURL(file);
                preview.style.display = "block";
            }
        });
    </script>
@endsection
