@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">








        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong>{{ session('success') }}</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        @endif




        <div class="card">
            <div class="card-header"><strong>Salesman List</strong></div>
            <div class="card-body">
                <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                        class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                <a class="btn btn-success mb-3" href="{{ url('salesman/create') }}"><i
                        class="bi bi-plus-circle pr-1"></i>Create</a>

                <table class="table table-hover table-responsive-lg">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Branch</th>
                            <th scope="col">Name</th>
                            <th scope="col">NIC</th>
                            <th scope="col">DOB</th>
                            <th scope="col">Contacts</th>
                            <th scope="col">Email</th>

                            <th scope="col">Action</th>



                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($salesmans as $salesman)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $salesman->code }}</td>
                                <td>{{ $salesman->branch->name }}</td>
                                <td>{{ $salesman->name }}</td>
                                <td>{{ $salesman->nic }}</td>
                                <td>{{ $salesman->dob }}</td>
                                <td>{{ $salesman->mobile . ' / ' . $salesman->mobile }}</td>
                                <td>{{ $salesman->email }}</td>

                                <td>
                                    <div class="d-flex gap-1">
                                        <a href="{{ url('salesman/view/' . $salesman->id) }}"
                                            class="btn btn-primary btn-sm"><i class="bi bi-eye pr-1"></i>View</a>
                                        <a href="{{ url('salesman/edit/' . $salesman->id) }}"
                                            class="btn btn-warning btn-sm"><i class="bi bi-pencil pr-1"></i>Update</a>
                                      

                                    </div>

                                </td>

                            </tr>
                        @endforeach

                    </tbody>
                </table>

                {{-- pagination --}}
                <div class="pagination">
                    {{ $salesmans->links() }}
                </div>
            </div>
        </div>





    </div>



    </div>
@endsection

@section('script')
    <script>
     
    </script>
@endsection
