@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">



        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        @endif





        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong>{{ session('success') }}</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        @endif




        <div class="card">
            <div class="card-header"><strong>Invoice Payment Summery</strong></div>
            <div class="card-body">

                <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                        class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                {{-- <a class="btn btn-success mb-3" href="{{ url('grn/create') }}"><i class="bi bi-plus-circle pr-1"></i>Create</a> --}}


                <div class="row">


                    {{-- <form action="{{ url('reports/invoiceSummery/search') }}" method="GET">
                        @csrf
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Date : </label>
                                <div class="col-sm-8">
                                    <input type="date" name="start_date" class="form-control" value="{{ date('Y-m-d') }}">
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label"></label>
                                <div class="col-sm-8">
                                    <input type="date" name="end_date" class="form-control" value="{{ date('Y-m-d') }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label"></label>
                                <div class="col-sm-8">
                                    <button class="btn btn-success" type="submit">Search</button>
                                </div>
                            </div>
                        </div>
                    </form>
 --}}


                    <div class="col-md-6 col-lg-6"></div>
                </div>





                <table class="table table-hover table-responsive fs-7">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Branch</th>
                            <th scope="col">Invoice Code</th>
                            <th scope="col">Invoice Date</th>
                            <th scope="col">Invoice Type</th>
                            <th scope="col">Invoice Status</th>
                            <th scope="col">Salesman</th>
                            <th scope="col">Customer Name</th>
                            <th scope="col">Item</th>
                 
                            <th scope="col">Payment Type</th>
                            <th scope="col">Payment Date</th>
                            <th scope="col">Payment Amount</th>
                            <th scope="col">Action</th>

                        </tr>
                    </thead>
                    <tbody>

                        @php
                            $total_payment = 0;
                            $total_payment_amount = 0;

                        @endphp

                        @if (isset($payments))
                            @foreach ($payments as $payment)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $payment->branch->name }}</td>
                                    <td>{{ $payment->invoice->code }}</td>
                                    <td>{{ $payment->invoice->date }}</td>
                                    <td>{{ $payment->invoice->type }}</td>
                                 
                                    <td><span
                                            class="badge rounded-pill {{ $payment->invoice->status == 'Processing' ? 'bg-success' : 'bg-warning' }}  ">{{ $payment->invoice->status }}</span>
                                    </td>

                                    <td>{{ $payment->invoice->salesman->name }}</td>
                                    <td>{{ $payment->invoice->customer_name }}</td>
                                    <td>{{ $payment->invoice->item->name }}</td>
        
                                    <td>{{ $payment->type }}</td>
                                    <td>{{ $payment->date }}</td>

                                    <td>{{ number_format($payment->amount, 2) }}</td>
                                    <td><a href="{{ url('invoice/view/' . $payment->invoice_id) }}"
                                            class="btn btn-secondary btn-sm"><i class="bi bi-eye pr-1"></i>View</a></td>

                           

                                    @php
                                        $total_payment++;
                                        $total_payment_amount += $payment->amount;
                                       
                                    @endphp

                         

                                </tr>
                            @endforeach
                        @endif



                    </tbody>
                </table>

                <div class="paginate">
                    {{$payments->links()}}
                </div>


                <div class="row">
                    <div class="col-md-4">







                    </div>
                    <div class="col-md-4">
                       
                    </div>
                    <div class="col-md-4">
                        <div class="row g-3 d-flex justify-content-end">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Payment</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="{{ $total_payment }}" style="width: 120px;">
                            </div>

                        </div>

                        
                        <div class="row g-3 d-flex justify-content-end pt-1">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                   Payment Amount</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="{{ number_format($total_payment_amount, 2) }}"
                                    style="width: 120px;">
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>





    </div>



    </div>
@endsection

@section('script')
    <script>
        //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete item data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });
    </script>
@endsection
