@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">



        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        @endif





        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong>{{ session('success') }}</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        @endif




        <div class="card">
            <div class="card-header"><strong>GRN Summery</strong></div>
            <div class="card-body">

                <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                        class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                {{-- <a class="btn btn-success mb-3" href="{{ url('grn/create') }}"><i class="bi bi-plus-circle pr-1"></i>Create</a> --}}


                <div class="row">


                    {{-- <form action="{{ url('reports/invoiceSummery/search') }}" method="GET">
                        @csrf
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Date : </label>
                                <div class="col-sm-8">
                                    <input type="date" name="start_date" class="form-control" value="{{ date('Y-m-d') }}">
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label"></label>
                                <div class="col-sm-8">
                                    <input type="date" name="end_date" class="form-control" value="{{ date('Y-m-d') }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label"></label>
                                <div class="col-sm-8">
                                    <button class="btn btn-success" type="submit">Search</button>
                                </div>
                            </div>
                        </div>
                    </form>
 --}}


                    <div class="col-md-6 col-lg-6"></div>
                </div>





                <table class="table table-hover table-responsive-lg fs-7">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Date</th>
                            <th scope="col">Branch</th>
                            <th scope="col">Vehicle Number</th>
                            <th scope="col">Total Item</th>
                            <th scope="col">Amount</th>
                            <th scope="col">Status</th>
                            <th scope="col">Action</th>

                        </tr>
                    </thead>
                    <tbody>

                        @php
                            $total_grn = 0;
                            $total_grn_amount = 0;
                            $total_item = 0;

                        @endphp

                        @if (isset($grns))
                            @foreach ($grns as $grn)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $grn->code }}</td>
                                    <td>{{ $grn->date }}</td>
                                    <td>{{ $grn->branch->name }}</td>
                                    <td>{{ $grn->vehicle_number }}</td>
                                    <td>{{ $grn->item_sum_qty }}</td>
                                    <td>{{ number_format($grn->total_amount, 2) }}</td>

                                    <td><span
                                            class="badge rounded-pill {{ $grn->status == 'Processing' ? 'bg-success' : 'bg-warning' }}  ">{{ $grn->status }}</span>
                                    </td>

                                    <td><a href="{{ url('grn/view/' . $grn->id) }}" class="btn btn-sm btn-secondary"><i class="bi bi-eye pr-1"></i>View</a>
                                    </td>

                                    @php
                                        $total_grn++;
                                        $total_grn_amount += $grn->total_amount;
                                        $total_item = $grn->item_sum_qty;
                                    @endphp



                                </tr>
                            @endforeach
                        @endif



                    </tbody>
                </table>


                <div class="paginate">
                    {{$grns->links()}}
                </div>

                <div class="row">
                    <div class="col-md-4">







                    </div>
                    <div class="col-md-4">
                        <div class="row g-3 d-flex justify-content-end">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    GRN</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="{{ $total_grn }}" style="width: 120px;">
                            </div>

                        </div>




                    </div>
                    <div class="col-md-4">
                        <div class="row g-3 d-flex justify-content-end">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Item</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="{{ $total_item }}" style="width: 120px;">
                            </div>

                        </div>

                        <div class="row g-3 d-flex justify-content-end pt-1">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Grn Amount</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="{{ number_format($total_grn_amount, 2) }}" style="width: 120px;">
                            </div>

                        </div>

                    </div>
                </div>

            </div>
        </div>





    </div>



    </div>
@endsection

@section('script')
    <script>
        //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete item data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });
    </script>
@endsection
