@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">



        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        @endif





        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong>{{ session('success') }}</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        @endif




        <div class="card">
            <div class="card-header"><strong>GRN Return Summery</strong></div>
            <div class="card-body">

                <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                        class="bi bi-skip-backward-circle pr-1"></i> Back</a>





                <table class="table table-hover table-responsive-lg fs-7">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Date</th>
                            <th scope="col">Branch</th>
                            <th scope="col">Vehicle Number</th>
                            <th scope="col">Person Name</th>
                            <th scope="col">Status</th>
                            <th scope="col">Total Item</th>
                            <th scope="col">Total Amount</th>

                            <th scope="col">Action</th>

                        </tr>
                    </thead>
                    <tbody>

                        @php
                            $total_grn_return = 0;
                            $total_grn_return_amount = 0;
                            $total_item = 0;
                        @endphp

                        @foreach ($grnReturns as $grnReturn)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $grnReturn->code }}</td>
                                <td>{{ $grnReturn->date }}</td>
                                <td>{{ $grnReturn->branch->name }}</td>
                                <td>{{ $grnReturn->vehicle_number }}</td>
                                <td>{{ $grnReturn->person_name }}</td>
                                <td><span
                                        class="badge rounded-pill {{ $grnReturn->status == 'Processing' ? 'bg-success' : 'bg-warning' }}  ">{{ $grnReturn->status }}</span>
                                </td>


                                <td>{{ $grnReturn->item_sum_qty }}</td>
                                <td>{{ number_format($grnReturn->total_sum, 2) }}</td>
                                <td>
                                    <div class="d-flex gap-1">
                                        <a href="{{ url('grnReturn/view/' . $grnReturn->id) }}"
                                            class="btn btn btn-secondary btn-sm"><i class="bi bi-eye pr-1"></i>view</a>

                                    </div>

                                </td>

                            </tr>

                            @php
                                $total_grn_return++;
                                $total_grn_return_amount += $grnReturn->total_sum;
                                $total_item += $grnReturn->item_sum_qty;
                            @endphp
                        @endforeach

                    </tbody>
                </table>

                <div class="paginate">
                    {{$grnReturns->links()}}
                </div>

                <div class="row">
                    <div class="col-md-4">







                    </div>
                    <div class="col-md-4">
                        <div class="row g-3 d-flex justify-content-end">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    GRN Return</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="{{ $total_grn_return }}" style="width: 120px;">
                            </div>

                        </div>




                    </div>
                    <div class="col-md-4">
                        <div class="row g-3 d-flex justify-content-end">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Item</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="{{ $total_item }}" style="width: 120px;">
                            </div>

                        </div>

                        <div class="row g-3 d-flex justify-content-end pt-1">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Grn Return Amount</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total" class="form-control form-control-sm text-end" readonly
                                    value="{{ number_format($total_grn_return_amount, 2) }}" style="width: 120px;">
                            </div>

                        </div>

                    </div>
                </div>

            </div>
        </div>





    </div>



    </div>
@endsection

@section('script')
    <script>
        //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete GRN Return data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });
    </script>
@endsection
