 @extends('template.layout')
 @section('style')
 @endsection

 @section('content')
     <div class="container">

         <div class="alert-section">
             @if ($errors->any())
                 <div class="alert alert-danger alert-dismissible fade show" role="alert">

                     <ul class="list-unstyled m-0 p-0">
                         @foreach ($errors->all() as $error)
                             <li>
                                 {{ $error }}
                             </li>
                         @endforeach

                     </ul>
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                         <span aria-hidden="true">&times;</span></button>
                 </div>
             @endif



             {{-- execption error --}}
             @if (session('error'))
                 <div class="alert alert-error alert-dismissible fade show" role="alert">
                     {{ session('error') }}
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                         <span aria-hidden="true">&times;</span></button>
                 </div>
             @endif


             {{-- execption error --}}
             @if (session('success'))
                 <div class="alert alert-success alert-dismissible fade show" role="alert">
                     {{ session('success') }}
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                         <span aria-hidden="true">&times;</span></button>
                 </div>
             @endif



             @if (session('warning'))
                 <div class="alert alert-success alert-dismissible fade show" role="alert">
                     {{ session('warning') }}
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                         <span aria-hidden="true">&times;</span></button>
                 </div>
             @endif


         </div>

         @csrf
         <div class="invoice-list">








             <div class="card mb-3">
                 <div class="card-header"><strong>Invoice List</strong></div>
                 <div class="card-body">
                     <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                             class="bi bi-skip-backward-circle pr-1"></i> Back</a>


                     <form method="GET"
                         action="{{ url('invoice/getInvoiceDataByNameOrNicOrBillNumberOrContacts/' . $idBranch) }}">
                         @csrf

                         <div class="row">
                             <div class="col"></div>

                             <div class="col">
                                 <div class="d-flex align-items-center gap-2 mb-2">
                                     <input type="text" class="form-control" name="query_type"
                                         placeholder="Name / Bill No / NIC ">
                                     <button type="submit" class="btn btn-primary mt-1">Search</button>

                                 </div>

                             </div>
                         </div>



                     </form>






                     <table class="table table-hover table-responsive-lg">
                         <thead>
                             <tr>
                                 <th scope="col">#</th>
                                 <th scope="col">Date</th>
                                 <th scope="col">Code</th>
                                 <th scope="col">Customer Name</th>
                                 <th scope="col">NIC</th>
                                 <th scope="col">Salesman</th>
                                 <th scope="col">Item</th>
                                 <th scope="col">Status</th>
                                 <th scope="col">Bill Amount</th>
                                 <th scope="col">Paid</th>
                                 <th scope="col">Not Paid</th>
                                 <th scope="col">Payment</th>
                                 <th scope="col">Action</th>
                             </tr>
                         </thead>
                         <tbody>

                             @foreach ($invoices as $invoice)
                                 <tr>
                                     <th>{{ $loop->iteration }}</th>
                                     <td>{{ $invoice->date }}</td>
                                     <td>{{ $invoice->code }}</td>
                                     <td>{{ $invoice->customer_name }}</td>
                                     <td>{{ $invoice->customer_nic }}</td>
                                     <td>{{ $invoice->salesman->name }}</td>
                                     <td>{{ $invoice->item->name }}</td>
                                     <td>

                                         @if ($invoice->status == 'Processing')
                                             <span class="badge badge-pill badge-primary p-1">{{ $invoice->status }}</span>
                                         @elseif($invoice->status == 'Complete')
                                             <span class="badge badge-pill badge-success p-1">{{ $invoice->status }}</span>
                                         @endif
                                     </td>


                                     <td class="text-end">{{ number_format($invoice->amount, 2) }}</td>
                                     <td class="text-end">{{ number_format($invoice->payment_sum_amount, 2) }}</td>
                                     <td class="text-end">
                                         {{ number_format($invoice->amount - $invoice->payment_sum_amount, 2) }}</td>


                                     <td>
                                         <form action="{{ url('payment/create/' . $invoice->id) }}" method="POST">
                                             @csrf
                                             <input type="number" class="form-control form-control-sm" name="payment">

                                     </td>

                                     <td>
                                         <div class="d-flex align-items-center gap-1"> <button type="submit"
                                                 class="btn btn-success btn-sm"><i class="bi bi-cash-coin"></i></button>
                                             </form>



                                             <a href="{{ url('invoice/view/' . $invoice->id) }}"
                                                 class="btn btn-sm btn-info"><i class="bi bi-eye"></i></a>
                                     </td>
                 </div>


                 </tr>
                 @endforeach




                 </tbody>
                 </table>












                 {{-- <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label"> </label>
                            <div class="col-sm-8">
                                <button class="btn btn-primary btn-block" type="submit">Find</button>
                            </div>
                        </div> --}}



             </div>
         </div>






     </div>

     <div class="todayPaymentData">

         <div class="card">
             <div class="card-header">Payment Data</div>
             <div class="card-body">
                 <table class="table table-hover table-responsive-lg">
                     <thead>
                         <tr>
                             <th scope="col">#</th>
                             <th scope="col">Code</th>
                             <th scope="col">Date</th>
                             <th scope="col">Invoice Code</th>
                             <th scope="col">Customer</th>
                             <th scope="col">Type</th>
                             <th scope="col">Amount</th>
                             <th scope="col">Action</th>
                         </tr>
                     </thead>
                     <tbody>

                         @foreach ($payments as $payment)
                             <tr>
                                 <th scope="row">{{ $loop->iteration }}</th>
                                 <td>{{ $payment->code }}</td>
                                 <td>{{ $payment->date }}</td>
                                 <td>{{ $payment->invoice->code }}</td>
                                 <td>{{ $payment->invoice->customer_name }}</td>
                                 <td>{{ $payment->type }}</td>
                                 <td>{{ number_format($payment->amount, 2) }}</td>
                                 <td>
                                     <form action="{{ url('payment/delete/' . $payment->id) }}" method="POST">
                                         @csrf
                                         @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger btn-delete"><i class="bi bi-trash3"></i></button>
                                     </form>
                                 </td>
                             </tr>
                         @endforeach




                     </tbody>
                 </table>
             </div>
         </div>


     </div>



     </div>
 @endsection

 @section('script')
     <script>
         // document 6 before upload
         // document.getElementById('picture').addEventListener('change', function(event) {
         //     const file = event.target.files[0];
         //     if (file) {
         //         const preview = document.getElementById('picture_preview');
         //         preview.src = URL.createObjectURL(file);
         //         preview.style.display = "block";
         //     }
         // });

         // this is typable selection box
         // new TomSelect("#item", {
         //     create: false,
         //     searchHighlight: true,
         //     // placeholder: "Select Branch",

         //     sortField: {
         //         field: "text",
         //         direction: "asc",

         //     }
         // });

         // new TomSelect("#invoice_list", {
         //     create: false,
         //     searchHighlight: true,
         //     // placeholder: "Select Branch",
         //     sortField: {
         //         field: "text",
         //         direction: "asc",

         //     }
         // });

         //visible down payment field
         // $('#bill_type').on('change', function() {
         //     let value = $(this).val();

         //     if (value == 'Cash') {
         //         $('#div_down_payment').hide();
         //     } else if (value == 'Installment') {
         //         $('#div_down_payment').show();
         //     }
         // });


         //delete confirmation message
         $('.btn-delete').click(function(e) {
             e.preventDefault();
             var form = $(this).parents('form');
             //alert('aaa');
             Swal.fire({
                 title: "Are you sure to delete payment data ?",
                 text: "You won't be able to revert this!",
                 icon: "warning",
                 showCancelButton: true,
                 confirmButtonColor: "#3085d6",
                 cancelButtonColor: "#d33",
                 confirmButtonText: "Yes, delete it!"
             }).then((result) => {
                 if (result.isConfirmed) {
                     // Swal.fire({
                     //   title: "Deleted!",
                     //   text: "Your file has been deleted.",
                     //   icon: "success"
                     // });
                     form.submit();
                 }
             });

         });
     </script>
 @endsection
