@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">


        <div class="row">



            <div class="col-md-8">

                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">

                        <ul class="list-unstyled m-0 p-0">
                            @foreach ($errors->all() as $error)
                                <li>
                                    {{ $error }}
                                </li>
                            @endforeach

                        </ul>
                    </div>
                @endif




                <div class="card">
                    <div class="card-header"><strong>View Item</strong></div>
                    <div class="card-body">
                       <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i class="bi bi-skip-backward-circle pr-1"></i> Back</a>


                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Name : </label>
                            <div class="col-sm-8">
                                <input type="text" name="name" readonly class ="form-control" value="{{ $item->name }}">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Min Quantity : </label>
                            <div class="col-sm-8">
                                <input type="number" readonly ="min_qty" class="form-control" value="{{ $item->min_qty }}">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Max Quantity : </label>
                            <div class="col-sm-8">
                                <input type="number" readonly name="max_qty" class="form-control"
                                    value="{{ $item->max_qty }}">
                            </div>
                        </div>



                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Note : </label>
                            <div class="col-sm-8">
                                <textarea class="form-control" readonly ="note" id="" cols="30" rows="4">{{ $item->note }}</textarea>
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Picture : </label>
                            <div class="col-sm-8">
                               
                                <img class="img img-thumbnail" id="picture_preview"
                                    src="{{ $item->image_name == null || $item->image_name == '' ? asset('storage/images/default/sample-image-document.jpg') : asset('storage/' . $item->image_name) }}"
                                    alt="" width="200" height="200">
                            </div>
                        </div>



                 


                    </div>
                </div>



            </div>
            <div class="col-md-4"></div>
        </div>



    </div>
@endsection

@section('script')
    <script>
        // document 6 before upload
        document.getElementById('picture').addEventListener('change', function(event) {
            const file = event.target.files[0];
            if (file) {
                const preview = document.getElementById('picture_preview');
                preview.src = URL.createObjectURL(file);
                preview.style.display = "block";
            }
        });
    </script>
@endsection
