@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">


        <div class="row">



            <div class="col-md-8">

                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">

                        <ul class="list-unstyled m-0 p-0">
                            @foreach ($errors->all() as $error)
                                <li>
                                    {{ $error }}
                                </li>
                            @endforeach

                        </ul>
                         <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </div>
                @endif

                  {{-- success message --}}
        <div>
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <ul class="list-unstyled m-0 p-0">
                        {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </ul>
                </div>
            @endif
        </div>

        {{-- error message --}}
        <div>
            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="list-unstyled m-0 p-0">
                        {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </ul>
                </div>
            @endif
        </div>


        {{-- warninig message --}}
        <div>
            @if (session('warning'))
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <ul class="list-unstyled m-0 p-0">
                        {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </ul>
                </div>
            @endif
        </div>






                <div class="card">
                    <div class="card-header"><strong>Create Item</strong></div>
                    <div class="card-body">
                       <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i class="bi bi-skip-backward-circle pr-1"></i> Back</a>

                        <form method="POST" action="{{ url('item/store') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Name : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="name" class="form-control">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Min Quantity : </label>
                                <div class="col-sm-8">
                                    <input type="number" name="min_qty" class="form-control">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Max Quantity : </label>
                                <div class="col-sm-8">
                                    <input type="number" name="max_qty" class="form-control">
                                </div>
                            </div>



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Note : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="note" id="" cols="30" rows="4"></textarea>
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Picture : </label>
                                <div class="col-sm-8">
                                    <input class="form-control" type="file" name="picture" id="picture">
                                    <img class="img img-thumbnail mt-3" id="picture_preview"
                                        src="{{ asset('storage/images/default/sample-image-document.jpg') }}" alt=""
                                        width="200" height="200">
                                </div>
                            </div>



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label"> </label>
                                <div class="col-sm-8">
                                    <button class="btn btn-primary btn-block" type="submit">Save</button>
                                </div>
                            </div>


                        </form>
                    </div>
                </div>



            </div>
            <div class="col-md-4"></div>
        </div>



    </div>
@endsection

@section('script')
<script>
    
            // document 6 before upload
            document.getElementById('picture').addEventListener('change', function(event) {
                const file = event.target.files[0];
                if (file) {
                    const preview = document.getElementById('picture_preview');
                    preview.src = URL.createObjectURL(file);
                    preview.style.display = "block";
                }
            });
</script>
@endsection
