@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">








        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong>{{ session('success') }}</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        @endif




        <div class="card">
            <div class="card-header"><strong>Item List</strong></div>
            <div class="card-body">
 <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                <a class="btn btn-success mb-3" href="{{ url('item/create') }}"><i class="bi bi-plus-circle pr-1"></i>Create</a>

                <table class="table table-hover table-responsive-lg">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Name</th>
                            <th scope="col">Min Qty</th>
                            <th scope="col">Max Qty</th>
                            <th scope="col">Action</th>

                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($items as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->code }}</td>
                                <td>{{ $item->name }}</td>
                                <td>{{ $item->min_qty }}</td>
                                <td>{{ $item->max_qty }}</td>
                                <td>
                                    <div class="d-flex gap-1">
                                        <a href="{{ url('item/view/' . $item->id) }}"
                                            class="btn btn-primary btn-sm"><i class="bi bi-eye pr-1"></i>View</a>
                                        <a href="{{ url('item/edit/' . $item->id) }}"
                                            class="btn btn-warning btn-sm"><i class="bi bi-pencil pr-1"></i>Update</a>
               
                                    </div>

                                </td>

                            </tr>
                        @endforeach

                    </tbody>
                </table>
                <div class="pagination">
                    {{$items->links()}}
                </div>
            </div>
        </div>





    </div>



    </div>
@endsection

@section('script')
    <script>
   
    </script>
@endsection
