@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">








        @if (session('success'))
            <div class="alert alert-success" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong>{{ session('success') }}</strong>
                </ul>
            </div>
        @endif


        <div class="row">
            <div class="col-md-8">

                <div class="card">
                    <div class="card-header"><strong>Select Branch</strong></div>
                    <div class="card-body">
                        <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                                class="bi bi-skip-backward-circle pr-1"></i> Back</a>


                        <table class="table table-hover table-responsive-lg fs-6">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Code</th>
                                    <th scope="col">Name</th>

                                    <th scope="col">Action</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($branches as $branch)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $branch->code }}</td>
                                        <td>{{ $branch->name }}</td>

                                        <td>
                                            <div class="d-flex gap-1">
                                                {{-- <a href="{{ url('invoice/create/' . $branch->id) }}"
                                                    class="btn btn-secondary btn-sm">Create </a> --}}

                                                <a href="{{ url('invoice/all/' . $branch->id) }}"
                                                    class="btn btn-primary btn-sm">Invoice Create</a>


                                                <a href="{{ url('payment/all/' . $branch->id) }}"
                                                    class="btn btn-secondary btn-sm"> Invoice Payment</a>


                                                {{-- <a href="{{ url('invoice/create/' . $branch->id) }}"
                                                    class="btn btn-secondary btn-sm"> Return</a> --}}

                                                {{-- <a href="{{ url('invoice/create/' . $branch->id) }}"
                                                    class="btn btn-secondary btn-sm"> Cancel</a> --}}

                                            </div>








                                        </td>

                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>



            </div>
            <div class="col-md-4"></div>
        </div>




    </div>



    </div>
@endsection

@section('script')
    <script>
        //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete branch data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });
    </script>
@endsection
