@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">

        <div class="alert-section">
            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">

                    <ul class="list-unstyled m-0 p-0">
                        @foreach ($errors->all() as $error)
                            <li>
                                {{ $error }}
                            </li>
                        @endforeach

                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                </div>
            @endif



            {{-- execption error --}}
            @if (session('error'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                </div>
            @endif


        </div>

        @csrf
        <div class="row">




            <div class="col-md-6">




                <div class="card mb-3">
                    <div class="card-header"><strong>Invoice Payment</strong></div>
                    <div class="card-body">
                        <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                                class="bi bi-skip-backward-circle pr-1"></i> Back</a>


                        <form method="GET" action="{{ url('invoice/getInvoiceDataForPayment') }}">
                            @csrf
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Invoice : </label>
                                <div class="col-sm-8">
                                    <select name="invoice" class="select-beast" id="invoice_list">
                                        <option value="0">Select Invoice</option>
                                        @foreach ($invoices as $invoice)
                                            <option value="{{ $invoice->id }}">
                                                {{ $invoice->customer_name . ' / ' . $invoice->code . ' / ' . $invoice->customer_nic }}
                                            </option>
                                        @endforeach
                                    </select>
                                    {{-- <input type="hidden" name="branch" value="{{ $idBranch }}"> --}}
                                    <button type="submit" class="btn btn-primary mt-1">Load Invoice Data</button>
                                </div>
                            </div>

                        </form>

                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Bill Amount : </label>
                            <div class="col-sm-8">
                                <input type="text" name="name" class="form-control" disabled
                                    value="{{ number_format($invoice->amount, 2) }}">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Paid Amount : </label>
                            <div class="col-sm-8">
                                <input type="text" name="name" class="form-control" disabled>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Not Paid Amount : </label>
                            <div class="col-sm-8">
                                <input type="text" name="name" class="form-control" disabled>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Status : </label>
                            <div class="col-sm-8">
                                <input type="text" name="name" class="form-control" disabled
                                    value="{{ $invoice->status }}">
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Amount : </label>
                            <div class="col-sm-8">
                                <input type="number" name="name" class="form-control">
                            </div>
                        </div>



                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Note : </label>
                            <div class="col-sm-8">
                                <textarea class="form-control" name="address" id="" cols="30" rows="4"></textarea>
                            </div>
                        </div>










                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label"> </label>
                            <div class="col-sm-8">
                                <button class="btn btn-primary btn-block" type="submit">Save</button>
                            </div>
                        </div>



                    </div>
                </div>


                <div class="card">
                    <div class="card-header">Payment Data</div>
                    <div class="card-body">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Date</th>
                                    <th scope="col">Type</th>
                                    <th scope="col">Amount</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($invoice->payment as $payment)
                                    <tr>
                                        <th scope="row">$loop->iteration</th>
                                        <td>{{ $payment->date }}</td>
                                        <td>{{ $payment->type }}</td>
                                        <td>{{ number_format($payment->amount, 2) }}</td>
                                    </tr>
                                @endforeach




                            </tbody>
                        </table>
                    </div>
                </div>



            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header"><strong>Invoice Data</strong></div>
                    <div class="card-body">


                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Date : </label>
                            <div class="col-sm-8">
                                <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}">

                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Name : </label>
                            <div class="col-sm-8">
                                <input type="text" name="nic" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">NIC : </label>
                            <div class="col-sm-8">
                                <input type="text" name="nic" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Contacts : </label>
                            <div class="col-sm-8">
                                <input type="text" name="mobile" class="form-control">
                            </div>
                        </div>




                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Address : </label>
                            <div class="col-sm-8">
                                <textarea class="form-control" name="address" id="" cols="30" rows="4"></textarea>
                            </div>
                        </div>





                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Salesman : </label>
                            <div class="col-sm-8">
                                <input type="text" name="salesman" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Item : </label>
                            <div class="col-sm-8">
                                <input type="text" name="item" class="form-control">

                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Bill Type : </label>
                            <div class="col-sm-8">
                                <input type="text" name="bill-type" class="form-control">
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Item Amount : </label>
                            <div class="col-sm-8">
                                <input type="double" name="amount" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Discount : </label>
                            <div class="col-sm-8">
                                <input type="double" name="discount" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Bill Amount : </label>
                            <div class="col-sm-8">
                                <input type="double" name="bill-amount" class="form-control">
                            </div>
                        </div>

                        <div class="form-group row" id="div_down_payment">
                            <label for="name" class="col-sm-4 col-form-label">Down Payment : </label>
                            <div class="col-sm-8">
                                <input type="double" name="down_payment" class="form-control" id="down_payment">
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Note : </label>
                            <div class="col-sm-8">
                                <textarea class="form-control" name="note" id="" cols="30" rows="4"></textarea>
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="name" class="col-sm-4 col-form-label">Picture : </label>
                            <div class="col-sm-8">

                                <img class="img img-thumbnail" id="picture_preview"
                                    src="{{ asset('storage/images/default/sample-image-document.jpg') }}" alt=""
                                    width="200" height="200">
                            </div>
                        </div>





                    </div>
                </div>


            </div>


        </div>



    </div>
@endsection

@section('script')
    <script>
        // document 6 before upload
        // document.getElementById('picture').addEventListener('change', function(event) {
        //     const file = event.target.files[0];
        //     if (file) {
        //         const preview = document.getElementById('picture_preview');
        //         preview.src = URL.createObjectURL(file);
        //         preview.style.display = "block";
        //     }
        // });

        // this is typable selection box
        // new TomSelect("#item", {
        //     create: false,
        //     searchHighlight: true,
        //     // placeholder: "Select Branch",

        //     sortField: {
        //         field: "text",
        //         direction: "asc",

        //     }
        // });

        new TomSelect("#invoice_list", {
            create: false,
            searchHighlight: true,
            // placeholder: "Select Branch",
            sortField: {
                field: "text",
                direction: "asc",

            }
        });

        //visible down payment field
        $('#bill_type').on('change', function() {
            let value = $(this).val();

            if (value == 'Cash') {
                $('#div_down_payment').hide();
            } else if (value == 'Installment') {
                $('#div_down_payment').show();
            }
        });
    </script>
@endsection
