@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">

        <div class="alert-section">
            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">

                    <ul class="list-unstyled m-0 p-0">
                        @foreach ($errors->all() as $error)
                            <li>
                                {{ $error }}
                            </li>
                        @endforeach

                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                </div>
            @endif



            {{-- execption error --}}
            @if (session('error'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                </div>
            @endif


        </div>
        <form method="POST" action="{{ url('invoice/store') }}" enctype="multipart/form-data">
            @csrf
            <div class="row">




                <div class="col-md-6">




                    <div class="card mb-3">
                        <div class="card-header"><strong>Customer Data</strong></div>
                        <div class="card-body">
                            <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                                    class="bi bi-skip-backward-circle pr-1"></i> Back</a>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Name : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="name" class="form-control">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">NIC : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="nic" class="form-control">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Mobile : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="mobile" class="form-control">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Land : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="land" class="form-control">
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Address : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="address" id="" cols="30" rows="4"></textarea>
                                </div>
                            </div>









                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label"> </label>
                                <div class="col-sm-8">
                                    <button class="btn btn-primary btn-block" type="submit">Save</button>
                                </div>
                            </div>



                        </div>
                    </div>



                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header"><strong>Invoice Data</strong></div>
                        <div class="card-body">


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Date : </label>
                                <div class="col-sm-8">
                                    <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}">

                                </div>
                            </div>



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Salesman : </label>
                                <div class="col-sm-8">
                                    <select name="salesman" class="select-beast" id="salesman">
                                        <option value="0">Select Salesman</option>
                                        @foreach ($salesmans as $salesman)
                                            <option value="{{ $salesman->id }}">{{ $salesman->name }}</option>
                                        @endforeach
                                    </select>
                                    <input type="hidden" name="branch" value="{{ $idBranch }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Item : </label>
                                <div class="col-sm-8">
                                    <select name="item" class="select-beast" id="item">
                                        <option value="0">Select Item</option>
                                        @foreach ($stockItems as $stockItem)
                                            @if ($stockItem->qty > 0)
                                                <option value="{{ $stockItem->id }}">
                                                    {{ $stockItem->item->name . ' / ' . number_format($stockItem->price_sell, 2) . ' / ' . $stockItem->qty }}
                                                </option>
                                            @else
                                            @endif
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Bill Type : </label>
                                <div class="col-sm-8">
                                    <select name="billType" class="form-control" id="bill_type">
                                        <option value="Installment">Installment</option>
                                        <option value="Cash">Cash</option>
                                    </select>
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Amount : </label>
                                <div class="col-sm-8">
                                    <input type="double" name="amount" class="form-control">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Discount : </label>
                                <div class="col-sm-8">
                                    <input type="double" name="discount" class="form-control">
                                </div>
                            </div>


                            <div class="form-group row" id="div_down_payment">
                                <label for="name" class="col-sm-4 col-form-label">Down Payment : </label>
                                <div class="col-sm-8">
                                    <input type="double" name="down_payment" class="form-control" id="down_payment">
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Note : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="note" id="" cols="30" rows="4"></textarea>
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Picture : </label>
                                <div class="col-sm-8">
                                    <input class="form-control" type="file" name="picture" id="picture">
                                    <img class="img img-thumbnail mt-3" id="picture_preview"
                                        src="{{ asset('storage/images/default/sample-image-document.jpg') }}"
                                        alt="" width="200" height="200">
                                </div>
                            </div>





                        </div>
                    </div>


                </div>


            </div>

        </form>

    </div>
@endsection

@section('script')
    <script>
        // document 6 before upload
        document.getElementById('picture').addEventListener('change', function(event) {
            const file = event.target.files[0];
            if (file) {
                const preview = document.getElementById('picture_preview');
                preview.src = URL.createObjectURL(file);
                preview.style.display = "block";
            }
        });

        // this is typable selection box
        new TomSelect("#item", {
            create: false,
            searchHighlight: true,
            // placeholder: "Select Branch",

            sortField: {
                field: "text",
                direction: "asc",

            }
        });

        new TomSelect("#salesman", {
            create: false,
            searchHighlight: true,
            // placeholder: "Select Branch",
            sortField: {
                field: "text",
                direction: "asc",

            }
        });

        //visible down payment field
        $('#bill_type').on('change', function() {
            let value = $(this).val();

            if (value == 'Cash') {
                $('#div_down_payment').hide();
            } else if (value == 'Installment') {
                $('#div_down_payment').show();
            }
        });
    </script>
@endsection
