@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">

        <div class="alert-section">

            @if ($errors->any())
                <div class="alert alert-danger" role="alert">

                    <ul class="list-unstyled m-0 p-0">
                        @foreach ($errors->all() as $error)
                            <li>
                                {{ $error }}
                            </li>
                        @endforeach

                    </ul>
                </div>
            @endif

            {{-- success alert --}}
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">

                    {{ session('success') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                </div>
            @endif


            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">

                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                </div>
            @endif



            @if (session('warning'))
                <div class="alert alert-warning alert-dismissible fade show" role="alert">

                    {{ session('warning') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                </div>
            @endif
        </div>




        <form method="POST" action="{{ url('invoice/update/' . $invoice->id) }}" enctype="multipart/form-data">
            @csrf
            @method('PUT')


            {{-- invoice main data --}}
            <div class="card">
                <div class="card-header"><strong>Edit Invoice</strong></div>



                <div class="card-body">
                    <div class="row">
                        <div> <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                                    class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                        </div>
                        <div class="col-md-6">



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Name : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="name" class="form-control"
                                        value="{{ $invoice->customer_name }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">NIC : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="nic" class="form-control"
                                        value="{{ $invoice->customer_nic }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Mobile : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="mobile" class="form-control"
                                        value="{{ $invoice->customer_mobile }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Land : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="land" class="form-control"
                                        value="{{ $invoice->customer_land }}">
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Address : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="address" id="" cols="30" rows="4">{{ $invoice->customer_address }}</textarea>
                                </div>
                            </div>












                        </div>
                        <div class="col-md-6">

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Date : </label>
                                <div class="col-sm-8">
                                    <input type="date" name="date" class="form-control" value="{{ $invoice->date }}"
                                        disabled>

                                </div>
                            </div>



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Salesman : </label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" value="{{ $invoice->salesman->name }}"
                                        disabled>
                                    {{-- <input type="hidden" name="branch" value="{{ $idBranch }}"> --}}
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Item : </label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" value="{{ $invoice->item->name }}"
                                        disabled>

                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Bill Type : </label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" value="{{ $invoice->type }}" disabled>
                                </div>
                            </div>

                             <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Status : </label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" value="{{ $invoice->status }}" disabled>
                                </div>
                            </div>



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Amount : </label>
                                <div class="col-sm-8">
                                    <input type="double" name="amount" class="form-control"
                                        value="{{ number_format($invoice->amount, 2) }}" disabled>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Discount : </label>
                                <div class="col-sm-8">
                                    <input type="double" name="discount" class="form-control"
                                        value="{{ number_format($invoice->discount, 2) }}" disabled>
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Note : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="note" id="" cols="30" rows="4">{{ $invoice->note }}</textarea>
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Picture : </label>
                                <div class="col-sm-8">
                                    <input class="form-control" type="file" name="picture" id="picture">
                                    <img class="img img-thumbnail mt-3" id="picture_preview"
                                        src="{{ !($invoice->picture_name == '' || $invoice->picture_name == null) ? asset('storage/' . $invoice->picture_name) : asset('storage/images/default/sample-image-document.jpg') }}"
                                        alt="" width="200" height="200">

                                    <div class="ml-3 mt-2">
                                        <input type="checkbox" class="form-check-input" id="picture_remove"
                                            name="picture_remove"
                                            {{ $invoice->picture_name == null || $invoice->picture_name == '' ? 'disabled' : '' }}>
                                        <label class="form-check-label text-danger" for="picture_remove">Remove
                                            Image</label>
                                    </div>
                                </div>


                            </div>


                            <div class="form-group row mt-3">
                                <label for="name" class="col-sm-4 col-form-label"> </label>
                                <div class="col-sm-8">
                                    <div class="d-flex gap-1">
                                        <button class="btn btn-primary" type="submit" id="btn-edit"><i
                                                class="bi bi-pencil-square pr-1"></i>Edit</button>
        </form>

        <form action="{{ url('invoice/delete/' . $invoice->id) }}" method="POST">
            @csrf
            @method('DELETE')


            <button class="btn btn-danger btn-delete" type="submit" id="btn-delete"><i
                    class="bi bi-trash3 pr-1"></i>Delete</button>
        </form>

    </div>
    </div>
    </div>
    </div>



    <div class="invoice_payment_data mt-3">
            <div class="card">
                <div class="card-header">
                    <strong>Payment Data</strong>
                </div>
                <div class="card-body">

                    @php
                        $total_payment = 0;
                        $total_amount = 0;
                    @endphp

                    <table class="table table-hover table-responsive-lg fs-6">
                        <thead class="thead-light">
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Code</th>
                                <th scope="col">Date</th>
                                <th scope="col">Type</th>
                                <th scope="col">Amount</th>
                                <th scope="col">Action</th>



                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($invoice->payment as $payment)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $payment->code }}</td>
                                    <td>{{ $payment->date }}</td>
                                    <td>{{ $payment->type }}</td>
                                    <td>{{ number_format($payment->amount, 2) }}</td>

                                    <td>
                                        <form action="{{ url('payment/delete/' . $payment->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit"
                                                class="btn btn-sm btn-outline-danger btn-delete"><i class="bi bi-trash3"></i></button>
                                        </form>
                                    </td>


                                    @php
                                        $total_payment++;
                                        $total_amount += $payment->amount;
                                    @endphp


                                    </td>

                                </tr>
                            @endforeach

                        </tbody>
                    </table>


                    <div class="total_data">
                        <div class="row g-3 d-flex justify-content-end">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Payment</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total_payment"
                                    class="form-control form-control-sm text-end fw-bold" readonly
                                    value="{{ $total_payment }}" style="width: 120px;">
                            </div>

                        </div>


                        <div class="row g-3 d-flex justify-content-end pt-1">
                            <div class="col-auto">
                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                    Amount</label>
                            </div>
                            <div class="col-auto">
                                <input type="text" name="total_amount"
                                    class="form-control form-control-sm text-end fw-bold" readonly
                                    value="{{ number_format($total_amount, 2) }}" style="width: 120px;">
                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>




    <div class="row mt-3" >
            <div class="col-md-6 mb-3" >
                <div class="card">
                    <div class="card-header text-danger"><strong>Return Invoice</strong></div>
                    <div class="card-body">

                        <form action="{{ url('invoiceHasReturn/create/' . $invoice->id) }}" method="POST">
                            @csrf

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Is return invoice : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="is-return" class="form-control"
                                        value="{{ $invoice->return ? 'Yes' : 'No' }}" disabled>

                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Date : </label>
                                <div class="col-sm-8">
                                    <input type="date" name="date" class="form-control" value="{{$invoice->return ? $invoice->return->date : ''}}">

                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Return Amount : </label>
                                <div class="col-sm-8">
                                    <input type="textx" name="amount" class="form-control" value="{{$invoice->return ? number_format($invoice->return->amount,2) : ''}}">

                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Note : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" id="" cols="30" rows="5" name="note">{{$invoice->return ? $invoice->return->note :''}}</textarea>

                                </div>
                            </div>

                            <div class="form-group row">
                                <div class="col-sm-4"></div>
                                <div class="col-sm-8">
                                    <div class="d-flex align-items-center gap-2">

                                        <button type="submit" class="btn btn-danger" id="btn-return">Return
                                            </button>
                        </form>

                        <form action="{{ url('invoiceHasReturn/delete/' . $invoice->id) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-secondary" id="btn-return-remove">Remove
                                Return</button>
                    </div>
                </div>
                </form>
            </div>
    </div>
</div>
</div>

  

 <div class="col-md-6 mb-3">
        <div class="card">
            <div class="card-header text-warning"><strong>Cancel Invoice</strong></div>
            <div class="card-body">


                <form action="{{ url('invoiceHasCancel/create/' . $invoice->id) }}" method="POST">
                    @csrf

                    <div class="form-group row">
                        <label for="name" class="col-sm-4 col-form-label">Is cancel invoice : </label>
                        <div class="col-sm-8">
                            <input type="text" name="is-cancel-invoice" class="form-control"
                                value="{{ $invoice->cancel ? 'Yes' : 'No' }}" disabled>

                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="name" class="col-sm-4 col-form-label">Date : </label>
                        <div class="col-sm-8">
                            <input type="date" name="date" class="form-control" value="{{$invoice->cancel ? $invoice->cancel->date : ''}}">

                        </div>
                    </div>

                    <div class="form-group row">
                        <label for="name" class="col-sm-4 col-form-label">Note : </label>
                        <div class="col-sm-8">
                            <textarea class="form-control" cols="30" rows="5" name="note">{{ $invoice->cancel != null ? $invoice->cancel->note : '' }}</textarea>

                        </div>
                    </div>

                    <div class="form-group row">
                        <div class="col-sm-4"></div>
                        <div class="col-sm-8">
                            <div class="d-flex align-items-center gap-2">

                                <button type="submit" class="btn btn-warning" id="btn-cancel">Cancel
                                    </button>
                </form>

                <form action="{{ url('invoiceHasCancel/delete/' . $invoice->id) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" id="btn-cancel-remove">Remove
                        Cancel</button>
                </form>
            </div>


        </div>
   
    </div>

       
    </div>



   










@endsection




@section('script')
    <script>
        // document 6 before upload
        document.getElementById('picture').addEventListener('change', function(event) {
            const file = event.target.files[0];
            if (file) {
                const preview = document.getElementById('picture_preview');
                preview.src = URL.createObjectURL(file);
                preview.style.display = "block";
            }
        });





        //invoice edit validation
        $('#btn-edit').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure edit invoice data ?",
                text: "Please concern clearly before edit",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, update it !"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });


        //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete branch data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });


        // cancel confirmation
        $('#btn-cancel').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure cancel invoice data ?",
                text: "Cancel invoice is not allwo to make payment or edit",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, cancel it !"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });

        //remove cancel status
        $('#btn-cancel-remove').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure active invoice data ?",
                text: "this invoice is allow to make payment and edit after active",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, active it !"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });



        //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete payment data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });


        //invoice return confirmation
        $('#btn-return').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to return invoice ?",
                text: "return invoice will be restock",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, return it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });
    </script>
@endsection
