@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">







        {{-- success alert --}}
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">

                {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
            </div>
        @endif


         @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">

                {{ session('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
            </div>
        @endif

          @if (session('warning'))
            <div class="alert alert-warning alert-dismissible fade show" role="alert">

                {{ session('warning') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
            </div>
        @endif




        <div>

            <div class="card">
                <div class="card-header"><strong>Invoice List</strong></div>
                <div class="card-body">
                    <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                            class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                    <a class="btn btn-success mb-3" href="{{ url('invoice/create/' . $idBranch) }}"><i
                            class="bi bi-plus-circle pr-1"></i>Create</a>

                    <table class="table table-hover table-responsive fs-7">
                        <tbody>
                            <thead class="thead-light">



                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Code</th>
                                    <th scope="col">Date</th>
                                    <th scope="col">Salesman</th>
                                    <th scope="col">Customer Name</th>
                                    <th scope="col">Bill Ttype</th>
                                    <th scope="col">Item Name</th>
                                    <th scope="col">Item Amount</th>
                                    <th scope="col">Discount</th>
                                    <th scope="col">Bill Amount</th>
                                    <th scope="col">Paid Amount</th>
                                    <th scope="col">Not Amount</th>
                                    <th scope="col">Status</th>
                                    <th scope="col">Action</th>

                                </tr>
                            </thead>
                        <tbody>
                            @foreach ($invoices as $invoice)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $invoice->code }}</td>
                                    <td>{{ $invoice->date }}</td>
                                    <td>{{ $invoice->salesman->name }}</td>
                                    <td>{{ $invoice->customer_name }}</td>


                                    <td>{{ $invoice->type }}</td>
                                    <td>{{ $invoice->item->name }}</td>
                                    <td>{{ number_format($invoice->amount, 2) }}</td>
                                    <td>{{ number_format($invoice->discount, 2) }}</td>
                                    <td>{{ number_format($invoice->amount - $invoice->discount, 2) }}</td>
                                    <td>{{ number_format($invoice->payment_sum_amount, 2) }}</td>
                                    <td>{{ number_format($invoice->amount - $invoice->discount - $invoice->payment_sum_amount, 2) }}
                                    </td>
                                    <td>

                                        @if ($invoice->status == 'Complete')
                                            <span class="badge rounded-pill bg-info p-1">{{ $invoice->status }}</span>
                                        @elseif($invoice->status == 'Processing')
                                            <span class="badge rounded-pill bg-success p-1">{{ $invoice->status }}</span>
                                        @endif

                                    </td>

                                    <td>
                                        <div class="d-flex gap-1">
                                            <a href="{{ url('invoice/view/' . $invoice->id) }}"
                                                class="btn btn btn-primary btn-sm" data-bs-toggle="tooltip"
                                                title="View Invoice"><i class="bi bi-eye pr-1"></i>View</a>

                                            <a href="{{ url('invoice/edit/' . $invoice->id) }}"
                                                class="btn btn btn-warning btn-sm"><i class="bi bi-pencil pr-1"
                                                    data-bs-toggle="tooltip" title="Edit Invoice"></i>Update</a>

                                     

                                        </div>



                                    </td>

                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                    <div class="pagination">
                        {{ $invoices->links() }}
                    </div>
                </div>
            </div>




        </div>




    </div>



    </div>
@endsection

@section('script')
    <script>
    
    </script>
@endsection
