@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">


        <div class="row">



            <div class="col-md-8">

                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">

                        <ul class="list-unstyled m-0 p-0">
                            @foreach ($errors->all() as $error)
                                <li>
                                     {{ $error }}
                                </li>
                            @endforeach

                        </ul>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </div>
                @endif

                
            {{-- execption alert --}}
            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </div>
            @endif

            {{-- success alert --}}


            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <ul class="list-unstyled m-0 p-0">
                        {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </ul>
                </div>
            @endif



            @if (session('warning'))
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <ul class="list-unstyled m-0 p-0">
                        {{ session('warning') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </ul>
                </div>
            @endif





                <div class="card">
                    <div class="card-header"><strong>Create GRN Return</strong></div>
                    <div class="card-body">
                        <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                                class="bi bi-skip-backward-circle pr-1"></i> Back</a>



                        <form method="POST" action="{{ url('grnReturn/store') }}">
                            @csrf




                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Branch : </label>
                                <div class="col-sm-8">
                                    <select name="branch" id="branch" class="form-select">
                                        <option value="0">--Select One--</option>
                                        @foreach ($branches as $branch)
                                            <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Date : </label>
                                <div class="col-sm-8">
                                    <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Vehicle Number : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="vehicle_number" class="form-control">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Person Name : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="person_name" class="form-control">
                                </div>
                            </div>



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Note : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="note" id="" cols="30" rows="4"></textarea>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label"> </label>
                                <div class="col-sm-8">
                                    <button class="btn btn-primary btn-block" type="submit">Save</button>
                                </div>
                            </div>


                    </div>

                    </form>
                </div>
            </div>

            <div class="col-md-4"></div>

        </div>

    </div>





    </div>





@endsection

@section('script')
    </script>
@endsection
