@extends('template.layout')
@section('style')

@endsection

@section('content')
    <div class="container">


        <div class="row">
            <div class="alert-validation mb-0 pb-0">
                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul class="list-unstyled m-0 p-0">
                            @foreach ($errors->all() as $error)
                                <li>
                                    {{ $error }}
                                </li>
                            @endforeach

                        </ul>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </div>
                @endif

            </div>

            {{-- success message --}}
            <div>
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <ul class="list-unstyled m-0 p-0">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                        </ul>
                    </div>
                @endif
            </div>

            {{-- error message --}}
            <div>
                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul class="list-unstyled m-0 p-0">
                            {{ session('error') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                        </ul>
                    </div>
                @endif
            </div>

     {{-- error message --}}
            <div>
                @if (session('warning'))
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <ul class="list-unstyled m-0 p-0">
                            {{ session('warning') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                        </ul>
                    </div>
                @endif
            </div>




            <div class="col-md-8 mb-3">




                <div class="card">
                    <div class="card-header"><strong>Edit GRN Return</strong></div>
                    <div class="card-body">
                        <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i class="bi bi-skip-backward-circle pr-1"></i> Back</a>

                        <form method="POST" action="{{ url('grnReturn/update/' . $grnReturn->id) }}">
                            @csrf
                            @method('PUT')
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Branch : </label>
                                <div class="col-sm-8">
                                    <select name="branch" id="branch" class="form-select">
                                        <option value="0">--Select One--</option>
                                        @foreach ($branches as $branch)
                                            <option value="{{ $branch->id }}"
                                                {{ $branch->id == $grnReturn->branch_id ? 'selected' : '' }}>{{ $branch->name }}
                                            </option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Date : </label>
                                <div class="col-sm-8">
                                    <input type="date" name="date" class="form-control" value="{{ $grnReturn->date }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Vehicle Number : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="vehicle_number" class="form-control"
                                        value="{{ $grnReturn->vehicle_number }}">
                                </div>
                            </div>

                               <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Person Name : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="person_name" class="form-control"
                                        value="{{ $grnReturn->person_name }}">
                                </div>
                            </div>



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Note : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="note" id="" cols="30" rows="4">{{ $grnReturn->note }}</textarea>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Status : </label>
                                <div class="col-sm-8">
                                    <select name="status" class="form-select" disabled>
                                        <option value="Processing" {{ $grnReturn->status == 'Processing' ? 'selected' : '' }}>
                                            Processing
                                        </option>
                                        <option value="Complete" {{ $grnReturn->status == 'Complete' ? 'selected' : '' }}>
                                            Complete</option>

                                    </select>
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label"> </label>
                                <div class="col-sm-8">
                                    <div class="d-flex gap-1">

                                  
                                    <button class="btn btn-primary " id="btn-header-data-edit" type="submit"><i class="bi bi-pencil-square pr-1"></i>Update</button>
                                      </form>


                                      <form action="{{ url('grnReturn/delete/' . $grnReturn->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn btn btn-danger " id="btn-header-data-delete" type="submit"><i
                                                    class="bi bi-trash3 pr-1"></i>Delete</button>
                                        </form>

                                        </div>
                                </div>
                            </div>

                      
                    </div>


                </div>
            </div>

            <div class="col-md-4">
            </div>

        </div>


        <div class="row">
            <div class="md-8">
                <div class="card">
                    <div class="card-header">GRN Return Item Adding Form</div>
                    <div class="card-body">



                        <form action="{{ url('grnReturnHasItem/store/' . $grnReturn->id) }}" method="POST">

                            @csrf
                            <div class="row">
                                <div class="col">
                                    <input type="hidden" name="grnReturn" value="{{ $grnReturn->id }}">
                                    <label for="exampleInputEmail1" class="form-label col-form-label-sm mb-0">Item</label>
                                    <select name="item" class="select-beast" id="item">
                                        <option value="0">Select Item</option>
                                        @foreach ($items as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}
                                            </option>
                                        @endforeach

                                    </select>

                                </div>

                                <div class="col">
                                    <label for="exampleInputEmail1" class="form-label col-form-label-sm mb-0">Unit Price
                                        </label>
                                    <input type="double" class="form-control form-control" name="unit_price"
                                        aria-describedby="emailHelp">

                                </div>

                         

                                <div class="col">
                                    <label for="exampleInputEmail1" class="form-label col-form-label-sm mb-0">Qty</label>
                                    <input type="number" class="form-control form-control" name="qty"
                                        aria-describedby="emailHelp">
                                    <div class="d-flex justify-content-end">
                                        <button class="btn btn-sm btn-success mt-2" type="submit">Add Item</button>
                                    </div>
                                </div>



                            </div>




                        </form>







                        <div class="mt-3">
                            <table class="table table-hover table-responsive-lg" id="tbl-grn-item">
                                <thead class="thead-light">
                                    <tr>
                                        <th scope="col">#</th>
                                        <th>Code</th>
                                        <th>Name</th>
                                        <th>Unit Price</th>
                                     
                                        <th>Qty</th>
                                        <th>Total</th>
                                        <th>Action</th>

                                    </tr>
                                </thead>
                                <tbody>

                                    @php
                                        $total = 0; // initialize total
                                    @endphp

                                    @foreach ($grnReturn->item as $item)
                                        <tr>
                                            <th scope="row">{{ $loop->iteration }}</th>
                                            <td>{{ $item->code }}</td>
                                            <td>{{ $item->item->name }}</td>
                                            <td>{{ number_format($item->unit_price, 2) }}</td>
                                          
                                            <td>{{ $item->qty }}</td>
                                            <td>{{ number_format($item->unit_price * $item->qty, 2) }}</td>
                                            <td>
                                                <form action="{{ url('grnReturnHasItem/delete/' . $item->id) }}"
                                                    method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-outline-danger btn-sm btn-grn-item-remove"
                                                        type="submit"><i
                                                    class="bi bi-trash3 pr-1"></i></button>
                                                </form>
                                            </td>
                                        </tr>

                                        @php
                                            $total += $item->unit_price * $item->qty;
                                        @endphp
                                    @endforeach
                                </tbody>
                            </table>

                            <div class="row">
                                <div class="col">
                                    <form action="{{ url('grnReturnHasItemHasStock/store/' . $grnReturn->id) }}" method="POST">
                                        @csrf
                                       
                                        <button class="btn btn-warning btn-sm" id="btn-complete-grn-return">Complete GRN Return</button>
                                    </form>
                                </div>
                                <div class="col">

                                    <div class="total_data">
                                        <div class="row g-3 d-flex justify-content-end">
                                            <div class="col-auto">
                                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                                    Amount</label>
                                            </div>
                                            <div class="col-auto">
                                                <input type="text" name="total"
                                                    class="form-control form-control-sm text-end fw-bold" readonly
                                                    value="{{ number_format($total, 2) }}" style="width: 120px;">
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>


                    </div>
                </div>
            </div>
            <div class="md-4"></div>
        </div>

    </div>





    </div>





@endsection

@section('script')
    <script>
        // header data edit confirmation
        //edit confirmation message
        $('#btn-header-data-edit').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to update GRN Return header data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, update it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });

           // header data edit confirmation
        //edit confirmation message
        $('#btn-header-data-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete GRN header data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });

        //grn complete validation
        $('#btn-complete-grn-return').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure complete GRN and tranfer item to stock ?",
                text: "after this you wont be update branch and GRN item again. please check and confirm it",
                icon: "info",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, complete the GRN !"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });


        // grn item remove validation
        $('.btn-grn-item-remove').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure remove grn item from grn product list ?",
                text: "this item is not added to stock yet.",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, remove it !"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });


 // this is typable selection box
        new TomSelect("#item", {
            create: false,
            searchHighlight: true,
            // placeholder: "Select Branch",

            sortField: {
                field: "text",
                direction: "asc",

            }
        });

    </script>
@endsection
