@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">



        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        @endif





        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <ul class="list-unstyled m-0 p-0">
                    <strong>{{ session('success') }}</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                </ul>
            </div>
        @endif




        <div class="card">
            <div class="card-header"><strong>GRN Return List</strong></div>
            <div class="card-body">

                <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                        class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                <a class="btn btn-success mb-3" href="{{ url('grnReturn/create') }}"><i
                        class="bi bi-plus-circle pr-1"></i>Create</a>




                <table class="table table-hover table-responsive-lg">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Branch</th>
                            <th scope="col">Vehicle Number</th>
                            <th scope="col">Person Name</th>
                            <th scope="col">Status</th>
                            <th scope="col">Date</th>
                             <th scope="col">Total Item</th>
                              <th scope="col">Total Amount</th>
                            <th scope="col">Action</th>

                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($grnReturns as $grnReturn)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $grnReturn->code }}</td>
                                <td>{{ $grnReturn->branch->name }}</td>
                                <td>{{ $grnReturn->vehicle_number }}</td>
                                  <td>{{ $grnReturn->person_name }}</td>
                                <td><span
                                        class="badge rounded-pill {{ $grnReturn->status == 'Processing' ? 'bg-primary' : 'bg-warning' }}  ">{{ $grnReturn->status }}</span>
                                </td>
                                <td>{{ $grnReturn->date }}</td>
                                 <td>{{ $grnReturn->item_sum_qty }}</td>
                                  <td>{{ number_format($grnReturn->total_sum,2) }}</td>

                                <td>
                                    <div class="d-flex gap-1">
                                        <a href="{{ url('grnReturn/view/' . $grnReturn->id) }}"
                                            class="btn btn btn-primary btn-sm"><i class="bi bi-eye pr-1"></i>View</a>
                                        <a href="{{ url('grnReturn/edit/' . $grnReturn->id) }}"
                                            class="btn btn btn-warning btn-sm"><i class="bi bi-pencil pr-1"></i>Update</a>
                                        

                                    </div>

                                </td>

                            </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>





    </div>



    </div>
@endsection

@section('script')
    
    </script>
@endsection
