@extends('template.layout')
@section('style')

@endsection

@section('content')
    <div class="container">


        <div class="row">
            <div class="alert-validation mb-0 pb-0">
                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul class="list-unstyled m-0 p-0">
                            @foreach ($errors->all() as $error)
                                <li>
                                    {{ $error }}
                                </li>
                            @endforeach

                        </ul>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </div>
                @endif

            </div>

            {{-- success message --}}
            <div>
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <ul class="list-unstyled m-0 p-0">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                        </ul>
                    </div>
                @endif
            </div>

            {{-- error message --}}
            <div>
                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul class="list-unstyled m-0 p-0">
                            {{ session('error') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                        </ul>
                    </div>
                @endif
            </div>





            <div class="col-md-8 mb-3">




                <div class="card">
                    <div class="card-header"><strong>View GRN</strong></div>
                    <div class="card-body">
                        <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i class="bi bi-skip-backward-circle pr-1"></i> Back</a>

                        {{-- <form method="POST" action="{{ url('grn/update/' . $grn->id) }}">
                            @csrf
                            @method('PUT') --}}
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Branch : </label>
                                <div class="col-sm-8">
                                    <select name="branch" id="branch" class="form-select" disabled>
                                        <option value="0">--Select One--</option>
                                        @foreach ($branches as $branch)
                                            <option value="{{ $branch->id }}"
                                                {{ $branch->id == $grn->branch_id ? 'selected' : '' }}>{{ $branch->name }}
                                            </option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Date : </label>
                                <div class="col-sm-8">
                                    <input type="date" name="date" class="form-control" value="{{ $grn->date }}" disabled>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Vehicle Number : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="vehicle_number" class="form-control"
                                        value="{{ $grn->vehicle_number }}" disabled>
                                </div>
                            </div>



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Note : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="note" id="" cols="30" rows="4" disabled>{{ $grn->note }}</textarea>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Status : </label>
                                <div class="col-sm-8">
                                    <select name="status" class="form-select" disabled>
                                        <option value="Processing" {{ $grn->status == 'Processing' ? 'selected' : '' }}>
                                            Processing
                                        </option>
                                        <option value="Complete" {{ $grn->status == 'Complete' ? 'selected' : '' }}>
                                            Complete</option>

                                    </select>
                                </div>
                            </div>

{{-- 
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label"> </label>
                                <div class="col-sm-8">
                                    <button class="btn btn-primary " id="btn-header-data-edit" type="submit">Update</button>
                                </div>
                            </div> --}}

                        {{-- </form> --}}
                    </div>


                </div>
            </div>

            <div class="col-md-4">
            </div>

        </div>


        <div class="row">
            <div class="md-8">
                <div class="card">
                    <div class="card-header">GRN Items</div>
                    <div class="card-body">



                       







                        <div class="mt-3">
                            <table class="table table-hover table-responsive-lg" id="tbl-grn-item">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th>Code</th>
                                        <th>Name</th>
                                        <th>Price Buy</th>
                                        <th>Price Sell</th>
                                        <th>Qty</th>
                                        <th>Total</th>
                                        {{-- <th>Action</th> --}}

                                    </tr>
                                </thead>
                                <tbody>

                                    @php
                                        $total = 0; // initialize total
                                        $total_item=0;
                                    @endphp

                                    @foreach ($grn->item as $item)
                                        <tr>
                                            <th scope="row">{{ $loop->iteration }}</th>
                                            <td>{{ $item->code }}</td>
                                            <td>{{ $item->item->name }}</td>
                                            <td>{{ number_format($item->price_buy, 2) }}</td>
                                            <td>{{ number_format($item->price_sell, 2) }}</td>
                                            <td>{{ $item->qty }}</td>
                                            <td>{{ number_format($item->price_buy * $item->qty, 2) }}</td>
                                            {{-- <td>
                                                <form action="{{ url('grnHasItem/delete/' . $item->id) }}"
                                                    method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-danger btn-sm btn-grn-item-remove"
                                                        type="submit">Delete</button>
                                                </form>
                                            </td> --}}
                                        </tr>

                                        @php
                                            $total += $item->price_buy * $item->qty;
                                            $total_item+= $item->qty ;
                                        @endphp
                                    @endforeach
                                </tbody>
                            </table>

                            <div class="row">
                                <div class="col">
                                    {{-- <form action="{{ url('stocks/store/' . $grn->id) }}" method="POST">
                                        @csrf
                                        <button class="btn btn-warning btn-sm" id="btn-complete-grn">Complete GRN</button>
                                    </form> --}}
                                </div>
                                <div class="col">

                                    <div class="total_data">


                                        <div class="row g-3 d-flex justify-content-end">
                                            <div class="col-auto">
                                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                                    Item</label>
                                            </div>
                                            <div class="col-auto">
                                                <input type="text" name="total"
                                                    class="form-control form-control-sm text-end fw-bold" readonly
                                                    value="{{$total_item  }}" style="width: 120px;">
                                            </div>

                                        </div>

                                        <div class="row g-3 d-flex justify-content-end pt-1">
                                            <div class="col-auto">
                                                <label for="inputPassword6" class="col-form-label col-form-label-sm">Total
                                                    Amount</label>
                                            </div>
                                            <div class="col-auto">
                                                <input type="text" name="total"
                                                    class="form-control form-control-sm text-end fw-bold" readonly
                                                    value="{{ number_format($total, 2) }}" style="width: 120px;">
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>


                    </div>
                </div>
            </div>
            <div class="md-4"></div>
        </div>

    </div>





    </div>





@endsection

@section('script')
    <script>
        // header data edit confirmation
        //edit confirmation message
        $('#btn-header-data-edit').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to update GRN header data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, update it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });


        //grn complete validation
        $('#btn-complete-grn').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure complete GRN and tranfer item to stock ?",
                text: "after this you wont be update branch and GRN item again. please check and confirm it",
                icon: "info",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, complete the GRN !"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });


        // grn item remove validation
        $('.btn-grn-item-remove').click(function(e) {
            e.preventDefault();
            var form = $(this).parents('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure remove grn item from grn product list ?",
                text: "this item is not added to stock yet.",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, remove it !"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });
    </script>
@endsection
