@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">



    {{-- success message --}}
        <div>
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <ul class="list-unstyled m-0 p-0">
                        {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </ul>
                </div>
            @endif
        </div>

        {{-- error message --}}
        <div>
            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="list-unstyled m-0 p-0">
                        {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </ul>
                </div>
            @endif
        </div>


        {{-- warninig message --}}
        <div>
            @if (session('warning'))
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <ul class="list-unstyled m-0 p-0">
                        {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </ul>
                </div>
            @endif
        </div>





        <div class="card">
            <div class="card-header"><strong>GRN List</strong></div>
            <div class="card-body">
                
 <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                <a class="btn btn-success mb-3" href="{{ url('grn/create') }}"><i class="bi bi-plus-circle pr-1"></i>Create</a>


                

                <table class="table table-hover table-responsive-lg">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Branch</th>
                            <th scope="col">Vehicle Number</th>
                              <th scope="col">Status</th>
                            <th scope="col">Date</th>
                             <th scope="col">Total Item</th>
                              <th scope="col">Total Amount</th>
                            <th scope="col">Action</th>

                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($grns as $grn)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $grn->code }}</td>
                                <td>{{ $grn->branch->name }}</td>
                                <td>{{ $grn->vehicle_number }}</td>
                                <td><span class="badge rounded-pill {{$grn->status == 'Processing' ? 'bg-primary' : 'bg-warning'}}  ">{{$grn->status}}</span></td>
                                <td>{{ $grn->date }}</td>
                                 <td>{{ $grn->item_sum_qty }}</td>
                                 <td>{{number_format($grn->total_sum,2)}}</td>
                          
                                <td>
                                    <div class="d-flex gap-1">
                                        <a href="{{ url('item/view/' . $grn->id) }}"
                                            class="btn btn btn-primary btn-sm"><i class="bi bi-eye pr-1"></i>View</a>
                                        <a href="{{ url('grn/edit/' . $grn->id) }}"
                                            class="btn btn btn-warning btn-sm"><i class="bi bi-pencil pr-1"></i>Update</a>
                                   

                                    </div>

                                </td>

                            </tr>
                        @endforeach

                    </tbody>
                </table>

                <div class="pagination">
                    {{$grns->links()}}
                </div>
            </div>
        </div>





    </div>



    </div>
@endsection

@section('script')
    <script>
   
    </script>
@endsection
