@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">


        <div class="row">



            <div class="col-md-8">

                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">

                        <ul class="list-unstyled m-0 p-0">
                            @foreach ($errors->all() as $error)
                                <li>
                                    <strong> {{ $error }}</strong>
                                </li>
                            @endforeach

                        </ul>
                    </div>
                @endif




                <div class="card">
                    <div class="card-header"><strong>Edit Branch</strong></div>
                    <div class="card-body">
                        <a class="btn btn btn-outline-info mb-3" href="{{ url()->previous() }}"><i
                                class="bi bi-skip-backward-circle pr-1"></i>Back</a>

                        <form method="POST" action="{{ url('branch/update/' . $branch->id) }}">
                            @csrf
                            @method('PUT')
                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Name : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="name" class="form-control" value="{{ $branch->name }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Contact (Mobile) : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="mobile" class="form-control" value="{{ $branch->mobile }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Contact (Land) : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="land" class="form-control" value="{{ $branch->land }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Email : </label>
                                <div class="col-sm-8">
                                    <input type="text" name="email" class="form-control" value="{{ $branch->email }}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Address : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="address" id="" cols="30" rows="4">{{ $branch->address }}</textarea>
                                </div>
                            </div>



                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label">Note : </label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="note" id="" cols="30" rows="4"> {{ $branch->note }}</textarea>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="name" class="col-sm-4 col-form-label"> </label>
                                <div class="col-sm-8">
                                    <div class="d-flex gap-1">
                                    <button id="btn-edit" class="btn btn-primary" type="submit"><i class="bi bi-pencil-square pr-1"></i>Update</button>
                                </form>
                               
                                   <form action="{{ url('branch/delete/' . $branch->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn btn-danger btn-delete" type="submit"><i class="bi bi-trash3 pr-1"></i>Delete</button>
                                        </form>

                                      
                                        </div>
                                </div>
                            </div>

                     

                       

                             

                    </div>
                </div>



            </div>
            <div class="col-md-4"></div>
        </div>



    </div>
@endsection

@section('script')
    <script>
        //edit confirmation message
        $('#btn-edit').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to update branch data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, update it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });


     //delete confirmation message
        $('.btn-delete').click(function(e) {
            e.preventDefault();
            var form = $(this).closest('form');
            //alert('aaa');
            Swal.fire({
                title: "Are you sure to delete branch data ?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    // Swal.fire({
                    //   title: "Deleted!",
                    //   text: "Your file has been deleted.",
                    //   icon: "success"
                    // });
                    form.submit();
                }
            });

        });

    </script>
@endsection
