@extends('template.layout')
@section('style')
@endsection

@section('content')
    <div class="container">





        {{-- success message --}}
        <div>
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <ul class="list-unstyled m-0 p-0">
                        {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </ul>
                </div>
            @endif
        </div>

        {{-- error message --}}
        <div>
            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="list-unstyled m-0 p-0">
                        {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </ul>
                </div>
            @endif
        </div>


        {{-- warninig message --}}
        <div>
            @if (session('warning'))
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <ul class="list-unstyled m-0 p-0">
                        {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                    </ul>
                </div>
            @endif
        </div>



        <div class="card">
            <div class="card-header"><strong>Branch List</strong></div>
            <div class="card-body">
                <a class="btn btn btn-outline-info  mb-3" href="{{ url()->previous() }}"><i
                        class="bi bi-skip-backward-circle pr-1"></i> Back</a>
                <a class="btn btn-success mb-3" href="{{ url('branch/create') }}"><i
                        class="bi bi-plus-circle pr-1"></i>Create</a>

                <table class="table table-hover table-responsive-lg">
                    <thead class="thead-light">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Code</th>
                            <th scope="col">Name</th>
                            <th scope="col">Contact</th>
                            <th scope="col">Email</th>
                            <th scope="col">Action</th>

                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($branches as $branch)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $branch->code }}</td>
                                <td>{{ $branch->name }}</td>
                                <td>{{ $branch->mobile . '/' . $branch->land }}</td>
                                <td>{{ $branch->email }}</td>
                                
                                <td>
                                    <div class="d-flex gap-1">
                                        <a href="{{ url('branch/view/' . $branch->id) }}"
                                            class="btn btn-primary btn-sm"><i class="bi bi-eye pr-1"></i>View</a>
                                        <a href="{{ url('branch/edit/' . $branch->id) }}"
                                            class="btn btn-warning btn-sm"><i class="bi bi-pencil pr-1"></i>Update</a>
                                       

                                    </div>

                                </td>

                            </tr>
                        @endforeach

                    </tbody>
                </table>
                <div class="paginate">
                     {{ $branches->links() }}
                </div>
            </div>
        </div>





    </div>



    </div>
@endsection

@section('script')
    <script>
   
    </script>
@endsection
