<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->timestamps();

            // customer data
            $table->string('customer_name');
            $table->string('customer_nic')->nullable();
            $table->string('customer_mobile')->nullable();
            $table->string('customer_land')->nullable();
            $table->string("customer_address")->nullable();

            // invoice data
            $table->date('date');
            $table->enum('type', ['Cash', 'Installment'])->default('Cash');
            $table->double('amount');
            $table->double('discount')->nullable();
            $table->string('picture_name')->nullable();
            $table->string('note')->nullable();
            $table->string('code')->nullable();
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->enum('status', ['Processing', 'Complete', 'Cancel', 'Return'])->default('Processing');

            //forein id
            $table->foreignId('item_id')->constrained("items")->onDelete('cascade');
            $table->foreignId('stock_id')->constrained('stocks')->onDelete('cascade');
            $table->foreignId('branch_id')->constrained("branches")->onDelete('cascade');
            $table->foreignId('salesman_id')->constrained('salesmans')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
    }
};
