<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('grn_has_items', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->string('code')->nullable();
            $table->integer('qty');
            $table->double('price_buy')->nullable();
            $table->double('price_sell')->nullable();
            $table->foreignId('grn_id')->constrained('grns')->onDelete('cascade');
            $table->foreignId('item_id')->constrained('items')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('grn_has_items');
    }
};
