<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('stocks', function (Blueprint $table) {
            $table->double('price_buy')->nullable();
            $table->double('price_sell')->nullable();
            $table->integer('qty');
            $table->string("created_by")->nullable();
            $table->string('updated_by')->nullable();
            $table->foreignId('item_id')->constrained('items')->onDelete('cascade');
            $table->foreignId('branch_id')->constrained('branches')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('stocks', function (Blueprint $table) {
            $table->dropColumn('price_buy');
            $table->dropColumn('price_sell');
            $table->dropColumn('qty');
            $table->dropColumn('creted_by');
            $table->dropColumn('updated_by');
            $table->dropForeign('item_id');
            $table->dropColumn('item_id');
            $table->dropForeign('branch_id');
            $table->dropColumn('branch_id');
        });
    }
};
