<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('salesmen', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->string('code')->nullable();
            $table->string('name')->unique();
            $table->string('nic')->unique();
            $table->date('dob')->nullable();
            $table->string('mobile')->nullable();
            $table->string('land')->nullable();
            $table->string("address")->nullable();
            $table->string('profile_picture_name')->nullable();
            $table->string('email')->nullable()->unique();
            $table->string('note')->nullable();
            $table->string('created_by')->nullable();
            $table->string("updated_by")->nullable();
            $table->foreignId('branch_id')->constrained('branches')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('salesmen');
    }
};
