<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Stock extends Model
{
    use HasFactory;
    protected $fillable = ['qty', 'qty_1', 'grn_has_items_id', 'item_id', 'created_by', 'updated_by', 'price_buy', 'price_sell', 'branch_id'];


    public function item()
    {
        return $this->belongsTo(Item::class);
    }

    public function grnHasItem()
    {
        return $this->belongsTo(GrnHasItem::class);
    }

    public function branch()
    {
        return $this->belongsTo(branch::class);
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }
}
