<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Salesman extends Model
{
    use HasFactory;
    protected $table = 'salesmans';
    protected $fillable = [
        'name','nic','address','dob','email','note','created_by','updated_by','mobile','land','profile_picture_name','document_1','document_2','branch_id'
    ];

    public function branch(){
        return $this->belongsTo(branch::class);
    }

    public function images(){
        return $this->hasMany(SalesmanHasImages::class);
    }

    public function invoice(){
        return $this->hasOne(Invoice::class);
    }
}
