<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;
    protected $fillable = ['date', 'type', 'note', 'status', 'created_by', 'updated_by', 'picture_name', 'amount', 'discount', 'customer_name', 'customer_nic', 'customer_address', 'customer_mobile', 'customer_land', 'item_id', 'branch_id', 'salesman_id', 'stock_id'];

    public function branch()
    {
        return $this->belongsTo(branch::class);
    }

    public function item()
    {
        return $this->belongsTo(Item::class);
    }

    public function salesman()
    {
        return $this->belongsTo(Salesman::class);
    }

    public function stock()
    {
        return $this->belongsTo(Stock::class);
    }

    public function payment()
    {
        return $this->hasMany(Payment::class);
    }

    public function cancel()
    {
        return $this->hasOne(InvoiceHasCancel::class);
    }

    public function return()
    {
        return $this->hasOne(InvoiceHasReturn::class);
    }
}
