<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GrnReturnHasItem extends Model
{
    use HasFactory;
    protected $fillable = ['item_id', 'grn_return_id', 'qty', 'created_by', 'updated_by','unit_price'];

    public function item()
    {
        return $this->belongsTo(Item::class);
    }

    public function grnReturn()
    {
        return $this->belongsTo(GrnReturn::class);
    }

    public function grnReturnHasItemHasStock(){
        return $this->hasMany(GrnReturnHasItemHasStock::class);
    }
   
}
