<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GrnReturn extends Model
{
    use HasFactory;

    protected $fillable = ['date', 'vehicle_number', 'person_name', 'note', 'branch_id', 'created_by', 'updated_by'];

    public function branch()
    {
        return $this->belongsTo(branch::class);
    }

    public function item()
    {
        return $this->hasMany(GrnReturnHasItem::class);
    }
}
