<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GrnHasItem extends Model
{
    use HasFactory;


    protected $fillable = ['item_id','price_buy','price_sell','grn_id','created_by','updated_by','qty'];

    public function item()
    {
        return $this->belongsTo(Item::class);
    }

    public function stock(){
        return $this->hasOne(Stock::class,'grn_has_items_id');
    }
}
