<?php

namespace App\Http\Controllers;

use App\Models\branch;
use App\Models\Grn;
use App\Models\Stock;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class StockController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $branches = branch::with('stock')
        ->select('branches.*')
        ->withSum('stock','qty')
        ->selectRaw('(SELECT SUM(qty*price_buy) FROM stocks WHERE stocks.branch_id = branches.id) AS total_sum' )
        ->orderBy('branches.id','desc')
        ->paginate(10);
        return view('stocks/all',compact('branches'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $idGrn)
    {

        try {


            $grn =  Grn::with('item')->find($idGrn);
            // validate there are grn items
            if (count($grn->item) > 0) {
                DB::beginTransaction();

                //then loop the grn item and add to stock
                foreach ($grn->item as $item) {

                    //dd($item);

                    $stocks = [
                        'qty' => $item->qty,
                        'qty_1' => $item->qty,
                        'item_id' => $item->item->id,
                        'grn_has_items_id' => $item->id,
                        'branch_id' => $grn->branch_id,
                        'price_buy' => $item->price_buy,
                        'price_sell' => $item->price_sell

                    ];

                    //dd($stocks);

                    $stocks = Stock::create($stocks);
                    $stocks->code = 'SITM-' . str_pad($stocks->id, 5, '0', STR_PAD_LEFT);
                    $stocks->save();
                }


                //upate grn status as complete
                $grn =  Grn::findOrFail($idGrn);
                $grn->status = 'Complete';
                $grn->update();


                DB::commit();
                return redirect('grn/all')->with('success', "GRN completed successfully");
                //return ($grn->item);
            } else {
                return redirect('grn/edit/' . $idGrn)->with('error', "Sorry! empty grn item is not allow to complete.");
            }
        } catch (\Throwable $e) {
            DB::rollBack();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Stock  $stock
     * @return \Illuminate\Http\Response
     */
    public function show(Stock $stock,$idBranch)
    {
        //
        $stocks = Stock::where('branch_id',$idBranch)->with('item')->get();
        $branch = branch::find($idBranch);

        return view('stocks/view',compact('stocks','branch'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Stock  $stock
     * @return \Illuminate\Http\Response
     */
    public function edit(Stock $stock)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Stock  $stock
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Stock $stock)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Stock  $stock
     * @return \Illuminate\Http\Response
     */
    public function destroy(Stock $stock)
    {
        //
    }
}
