<?php

namespace App\Http\Controllers;

use App\Models\Invoice;
use App\Models\InvoiceHasCancel;
use Illuminate\Http\Request;
use App\Models\InvoiceHasReturn;
use App\Models\Stock;
use Illuminate\Support\Facades\DB;

class InvoiceHasReturnController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $idInvoice)
    {
        $request->validate([
            'amount' => 'required|nullable|integer',
            'date' => 'required|date',
            'note' => 'string|nullable|max:200',
        ]);

        try {

            DB::beginTransaction();

            $invoice = Invoice::with('return', 'item', 'stock')->findOrFail($idInvoice);


            if ($invoice->stock) {

                //validate previouse return is exist
                if ($invoice->return) {
                    return back()->with('warning', 'Return invoice not allow to return again');
                } else {
                    //create returnn data
                    $invoiceHasReturn = [
                        'invoice_id' => $invoice->id,
                        'date' => $request->date,
                        'note' => $request->note,
                        'amount' => $request->amount
                    ];

                    $invoiceHasReturn = InvoiceHasReturn::create($invoiceHasReturn);
                    $invoiceHasReturn->code = 'IHR-' . str_pad($invoiceHasReturn->id, 5, '0', STR_PAD_LEFT);
                    $invoiceHasReturn->update();

                    //return back stock qty
                    $stock = Stock::findOrfail($invoice->stock->id);
                    $stock->qty++;
                    $stock->save();

                    //finalize process
                    DB::commit();
                    return back()->with('success', 'Invoice return successfully');
                }
            } else {
                return back()->with('warning', 'Sorry! Invoice related stock data not found. Please try again. Thank you ');
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            return back()->with('error', $th->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\InvoiceHasReturn  $invoiceHasReturn
     * @return \Illuminate\Http\Response
     */
    public function show(InvoiceHasReturn $invoiceHasReturn)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\InvoiceHasReturn  $invoiceHasReturn
     * @return \Illuminate\Http\Response
     */
    public function edit(InvoiceHasReturn $invoiceHasReturn)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\InvoiceHasReturn  $invoiceHasReturn
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, InvoiceHasReturn $invoiceHasReturn)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\InvoiceHasReturn  $invoiceHasReturn
     * @return \Illuminate\Http\Response
     */
    public function destroy(InvoiceHasReturn $invoiceHasReturn,$idInvoice)
    {
         try {

            DB::beginTransaction();

            $invoice = Invoice::with('return', 'item', 'stock')->findOrFail($idInvoice);


            if ($invoice->return) {

                //validate previouse return is exist
                // if ($invoice->return) {
                //     return back()->with('warning', 'Return invoice not allow to return again');
                // } else {
                    //create returnn data
                    // $invoiceHasReturn = [
                    //     'invoice_id' => $invoice->id,
                    //     'date' => $request->date,
                    //     'note' => $request->note,
                    //     'amount' => $request->amount
                    // ];

                    // $invoiceHasReturn = InvoiceHasReturn::create($invoiceHasReturn);
                    // $invoiceHasReturn->code = 'IHR-' . str_pad($invoiceHasReturn->id, 5, '0', STR_PAD_LEFT);
                    // $invoiceHasReturn->update();

                    //return back stock qty
                    $stock = Stock::findOrfail($invoice->stock->id);
                    $stock->qty--;
                    $stock->save();

                    $invoice->return->delete();

                    //finalize process
                    DB::commit();
                    return back()->with('success', 'Invoice return data removed successfully');
                // }
            } else {
                return back()->with('warning', 'Sorry! Invoice return data not found');
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            return back()->with('error', $th->getMessage());
        }
    }

    public function invoiceHasReturnSummery(){
        
        //$invoiceHasReturns = Invoice::with('return')->get();
       // $invoiceHasReturns = InvoiceHasCancel::with('invoice')->get();
        $invoiceHasReturns = InvoiceHasReturn::with('invoice','invoice.payment')        
        ->orderBy('id','desc')
        ->paginate(5);

   
        // return $invoiceHasReturns;
      return view('reports/invoiceReturnSummery',compact('invoiceHasReturns'));
    }

}
//  ->selectRaw('(SELECT SUM(qty*unit_price)FROM grn_return_has_items WHERE grn_return_has_items.grn_return_id = grn_returns.id)AS total_sum')