<?php

namespace App\Http\Controllers;

use App\Models\Invoice;
use Illuminate\Http\Request;
use App\Models\InvoiceHasCancel;
use Illuminate\Support\Facades\DB;

class InvoiceHasCancelController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $idInvoice)
    {

        $request->validate([
            'date' => 'required|date',
            'note' => 'string||nullable|max:200'
        ]);

        $invoice = Invoice::findOrFail($idInvoice);


        DB::beginTransaction();

        try {
            //validate curent status is not cancel
            if ($invoice->status != 'Cancel') {
                // $invoice['status'] = 'Cancel';
                // $invoice->update();


                //create cancel data
                $invoiceHasCancel = [
                    'invoice_id' => $invoice->id,
                    'date' => $request->date,
                    'note' => $request->note,
                ];

                $invoiceHasCancel = InvoiceHasCancel::create($invoiceHasCancel);
                $invoiceHasCancel->code = 'IHC-' . str_pad($invoiceHasCancel->id, 5, '0', STR_PAD_LEFT);
                $invoiceHasCancel->update();

                DB::commit();

                return back()->with('success', 'Invoice cancel succeeded');
            } else {
                return back()->with('error', 'Sorry! Cancel invoice is not allow to cancel again.');
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            return back()->with('error', $th->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\InvoiceHasCancel  $invoiceHasCancel
     * @return \Illuminate\Http\Response
     */
    public function show(InvoiceHasCancel $invoiceHasCancel)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\InvoiceHasCancel  $invoiceHasCancel
     * @return \Illuminate\Http\Response
     */
    public function edit(InvoiceHasCancel $invoiceHasCancel)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\InvoiceHasCancel  $invoiceHasCancel
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, InvoiceHasCancel $invoiceHasCancel)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\InvoiceHasCancel  $invoiceHasCancel
     * @return \Illuminate\Http\Response
     */
    public function destroy(InvoiceHasCancel $invoiceHasCancel, $idInvoice)
    {
        $invoice = Invoice::with('cancel')->findOrFail($idInvoice);

        //check current status is cancel then 
        if ($invoice->cancel) {
            // $invocie->status = ''
            $invoice->cancel()->delete();
            return back()->with('success', 'Invoice active again.');
        } else {
            return back()->with('warning', 'Sorry! invoice current status must be cancel to active.');
        }
    }


    public function invoiceHasCancelSummery(){
        $invoiceHasCancels = InvoiceHasCancel::with('invoice','invoice.payment')
        ->orderBy('id','desc')
        ->paginate(10);

        //return $invoiceHasCancels;
        return view('reports/invoiceCancelSummery',compact('invoiceHasCancels'));
    }
}
