<?php

namespace App\Http\Controllers;

use App\Models\Stock;
use App\Models\GrnReturn;
use Illuminate\Http\Request;
use App\Models\GrnReturnHasItem;
use Illuminate\Support\Facades\DB;

class GrnReturnHasItemController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, $grnReturnId)
    {
        $request->validate([
            'item' => 'integer|required|gt:0',
            'qty' => 'integer|required|gt:0',
            'unit_price' => 'numeric|nullable'

        ], [
            'item.gt' => "Please select valid item"

        ]);



        try {
            DB::beginTransaction();
            $grnReturn = GrnReturn::with('item')->find($grnReturnId);

            //dd($grnReturn->branch_id);
            //get toatl qty of branch available and validate
            $stockAvailableQty = Stock::where('branch_id', $grnReturn->branch_id)->where('item_id', $request->item)->sum('qty');
            // $stockAvailableQty = Stock::where('branch_id', $grnReturn->branch_id)->sum('qty');
            //  $stockAvailableQty = Stock::where('item_id', $request->item)->sum('qty');
                       //dd($request->item);
                       //dd($grnReturn->branch_id);
                     //  dd($stockAvailableQty);

            //get total already added same qty to grn return has item
            $addedQtyGrnReturnHasItem = GrnReturnHasItem::where('grn_return_id', $grnReturnId)
                ->where('item_id', $request->item)->sum('qty');
//dd($request->item);
            //dd($request->qty);
     
            //dd($addedQtyGrnReturnHasItem);

            if ($request->qty < ($stockAvailableQty - $addedQtyGrnReturnHasItem)) {

                $grnReturnHasItem = [
                    'grn_return_id' => $grnReturnId,
                    'qty' => $request->qty,
                    'unit_price' => $request->unit_price,
                    'item_id' => $request->item,
                ];

                $grnReturnHasItem   =  GrnReturnHasItem::create($grnReturnHasItem);
                $grnReturnHasItem->code = 'GRHI-' . str_pad($grnReturnHasItem->id, 5, '0', STR_PAD_LEFT);
                $grnReturnHasItem->update();
                DB::commit();
                return back()->with('success', 'GRN Return Item added successfully');
            } else {
                return back()->with('warning', 'Sorry! return qty is not avaiable in the stock');
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            return back()->with('error', $th->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\GrnReturnHasItem  $grnReturnHasItem
     * @return \Illuminate\Http\Response
     */
    public function show(GrnReturnHasItem $grnReturnHasItem)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\GrnReturnHasItem  $grnReturnHasItem
     * @return \Illuminate\Http\Response
     */
    public function edit(GrnReturnHasItem $grnReturnHasItem)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\GrnReturnHasItem  $grnReturnHasItem
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, GrnReturnHasItem $grnReturnHasItem)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\GrnReturnHasItem  $grnReturnHasItem
     * @return \Illuminate\Http\Response
     */
    public function destroy(GrnReturnHasItem $grnReturnHasItem, $id)
    {
        $grnReturnHasItem = GrnReturnHasItem::findOrfail($id);
        $grnReturn = GrnReturn::findOrFail($grnReturnHasItem->grn_return_id);
        //validate if there stock data 
        //validate if grn return status is complete
        if ($grnReturn->status == 'Complete') {
            return back()->with('warning', 'Sorry! GRN Return must be processing to item edit');
        } else {
            $grnReturnHasItem->delete();
            return back()->with('success', 'GRN Return Item Removed successfully');
        }
    }
}
