<?php

namespace App\Http\Controllers;

use App\Models\Grn;
use App\Models\Item;
use App\Models\Stock;
use App\Models\branch;
use App\Models\GrnHasItem;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;

class GrnController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $grns = Grn::with('branch', 'item')
            ->select('grns.*')
            ->withSum('item', 'qty')
            ->selectRaw('(SELECT SUM(qty*price_buy)FROM grn_has_items WHERE grn_has_items.grn_id = grns.id)AS total_sum')
            ->orderBy('id', 'desc')->paginate(10);
        return view('grn/all', compact('grns'));
        //return $grns;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $branches = branch::all();
        $items = Item::all();
        return view('grn/new', compact('branches', 'items'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $request->validate([
            'branch' => 'required|integer|gt:0',
            'vehicle_number' => 'nullable|string|',
            'date' => 'date|required',
            'note' => 'string|nullable|max:200'
        ]);


        $grn = [
            'branch_id' => $request->branch,
            'vehicle_number' => $request->vehicle_number,
            'date' => $request->date,
            'note' => $request->note,
        ];

        $grn = Grn::create($grn);
        $grn->code = "GRN-" . str_pad($grn->id, 5, '0', STR_PAD_LEFT); // LN-001, LN-002 etc.
        $grn->save();

        return Redirect('grn/all')->with('success', 'GRN header data create successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Grn  $grn
     * @return \Illuminate\Http\Response
     */
    public function show(Grn $grn, $id)
    {
        $items = Item::all();
        $grn = Grn::with('item.item')->find($id);
        $branches = branch::all();

        return view('grn/view', compact('grn', 'branches', 'items'));
        //return $grn;

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Grn  $grn
     * @return \Illuminate\Http\Response
     */
    public function edit(Grn $grn, $id)
    {

        $items = Item::all();
        $grn = Grn::with('item.item')->find($id);
        $branches = branch::all();

        return view('grn/edit', compact('grn', 'branches', 'items'));
        //return $grn;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Grn  $grn
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Grn $grn, $id)
    {

        $request->validate([
            'branch' => 'required|gt:0',
            'vehicle_number' => 'string|nullable|max:50',
            'note' => 'nullable|string|max:200',
            'date' => 'date|nullable',
            'status' => 'required|in:Processing,Complete'
        ], [
            'branch.gt' => 'The valid branch must be select'
        ]);


        try {
            DB::beginTransaction();
            //check current status is processing and and update to complete but no any grn item then validate
            $grn =  Grn::with('item')->find($id);
            //if grn status is processing can update branch id
            if ($grn->status == 'Processing') {
                $grn->branch_id = $request->branch;
            }
            $grn->vehicle_number = $request->vehicle_number;
            $grn->note = $request->note;
            $grn->vehicle_number = $request->vehicle_number;
            $grn->note = $request->note;
            $grn->update();
            DB::commit();
            return redirect('grn/edit/' . $id)->with('success', "GRN Header data updated successfully");
        } catch (\Throwable $e) {
            //throw $th;
            DB::rollBack();
            //dd($e->getMessage());
            return redirect('grn/edit/' . $grn->id)->with('error', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Grn  $grn
     * @return \Illuminate\Http\Response
     */
    public function destroy(Grn $grn, $id)
    {

        //$grnHasItem =GrnHasItem::with('stock')->where('grn_id',$id)->get();
        $grnHasItem = GrnHasItem::where('grn_id', $id)->with('stock')->get();

        echo ('step 1');

        //return $grnHasItem;

        $isUsedStockData = 'false';
        foreach ($grnHasItem as $item) {
            // echo('qty-'.$item->stock->qty.' - '.$item->stock->qty_1);
            if ($item->stock->qty != $item->stock->qty_1) {

                $isUsedStockData = 'true';
                break;
            }
        }

        //echo ('sss');
        //echo ($isUsedStockData);
        try {
            DB::beginTransaction();
            if ($isUsedStockData == 'false') {
                echo ('false');

                //     //delete stock data
                foreach ($grnHasItem as $item) {
                    $stock = Stock::findOrfail($item->stock->id);
                    //echo($item->stock);

                    $stock->delete();
                }

                //         echo ('222');

                //         //delete grn has item data

                $grn = Grn::findOrFail($id);
                $grn->item()->delete();
                //         //delete grn header data
                $grn->delete();
                DB::commit();
                return redirect('grn/all')->with('success', 'All grn and related all data removed successfully');
            } else {
                return redirect('grn/all')->with('warning', 'Sorry! GRN data is used to issue invoice. Please remove that related invoice data and then try again. Thank you ');
            }
        } catch (\Throwable $e) {
            //throw $th;
            //DB::rollBack();
            return redirect('grn/all')->with('error', $e->getMessage());
        }
    }

    public function grnSummery()
    {
        //$grns = Grn::with('branch','item')->withSum('item','price_buy')->withCount('item','qty')->orderBy('id', 'desc')->get();
        $grns = Grn::with('branch', 'item')
            ->select('grns.*')
            ->selectRaw('(SELECT SUM(price_buy*qty) FROM grn_has_items WHERE grn_has_items.grn_id = grns.id) AS total_amount')
            ->withSum('item', 'qty')->orderBy('id', 'desc')->paginate(10);

        return view('reports/grnSummery', compact('grns'));
        //return $grns;
    }
}
