<?php

namespace App\Http\Controllers;

use App\Models\branch;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class BranchController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $branches = branch::orderBy('id', 'desc')->paginate(3);
        return view('branch/all', compact('branches'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('branch/new');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $request->validate([
            'name' => 'string|required|max:50',
            'mobile' => 'string|nullable|max:10',
            'land' => 'string|nullable|max:10',
            'email' => 'email|nullable',
            'address' => 'string|nullable|max:100',
            'note' => 'string|nullable|max:200'
        ]);


        $branch = [
            'name' => $request->name,
            'mobile' => $request->mobile,
            'land' => $request->land,
            'note' => $request->note,
            'address' => $request->address,
            'email' => $request->email
        ];

        $branch = branch::create($branch);
        $branch->code = "BN-" . str_pad($branch->id, 5, '0', STR_PAD_LEFT); // LN-001, LN-002 etc.
        $branch->save();



        return redirect('branch/all')->with('success', 'Branch added successfully!');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $branch = branch::findOrFail($id);
        return view('branch/view', compact('branch'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function edit(branch $branch, $id)
    {
        $branch  = branch::findOrFail($id);
        return view('branch/edit', compact('branch'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $branch = branch::findOrFail($id);
        $request->validate([
            'name' => ['string', 'required', 'max:50', Rule::unique('branches', 'name')->ignore($branch->id)],
            'mobile' => 'string|nullable|max:10',
            'land' => 'string|nullable|max:10',
            'email' => 'email|nullable',
            'address' => 'string|nullable|max:100',
            'note' => 'string|nullable|max:200'
        ]);


        $branch->name = $request->name;
        $branch->mobile = $request->mobile;
        $branch->land = $request->land;
        $branch->email = $request->email;
        $branch->address = $request->address;
        $branch->note = $request->note;

        $branch->update();

        return redirect('branch/all')->with('success', 'Branch data updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function destroy(branch $branch, $id)
    {
        branch::findOrFail($id)->delete();
        return redirect('branch/all')->with('success', 'Branch data deleted successfully!');
    }
}
